package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListActivityTypesResponse(
    typeInfos: Iterable[zio.aws.swf.model.ActivityTypeInfo],
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListActivityTypesResponse = {
    import ListActivityTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListActivityTypesResponse
      .builder()
      .typeInfos(typeInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListActivityTypesResponse.ReadOnly =
    zio.aws.swf.model.ListActivityTypesResponse.wrap(buildAwsValue())
}
object ListActivityTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListActivityTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListActivityTypesResponse =
      zio.aws.swf.model.ListActivityTypesResponse(
        typeInfos.map { item =>
          item.asEditable
        },
        nextPageToken.map(value => value)
      )
    def typeInfos: List[zio.aws.swf.model.ActivityTypeInfo.ReadOnly]
    def nextPageToken: Optional[PageToken]
    def getTypeInfos
        : ZIO[Any, Nothing, List[zio.aws.swf.model.ActivityTypeInfo.ReadOnly]] =
      ZIO.succeed(typeInfos)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListActivityTypesResponse
  ) extends zio.aws.swf.model.ListActivityTypesResponse.ReadOnly {
    override val typeInfos: List[zio.aws.swf.model.ActivityTypeInfo.ReadOnly] =
      impl
        .typeInfos()
        .asScala
        .map { item =>
          zio.aws.swf.model.ActivityTypeInfo.wrap(item)
        }
        .toList
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListActivityTypesResponse
  ): zio.aws.swf.model.ListActivityTypesResponse.ReadOnly = new Wrapper(impl)
}
