package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  ActivityId,
  EventId,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters._
final case class ActivityTaskScheduledEventAttributes(
    activityType: zio.aws.swf.model.ActivityType,
    activityId: ActivityId,
    input: Optional[Data] = Optional.Absent,
    control: Optional[Data] = Optional.Absent,
    scheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    scheduleToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    startToCloseTimeout: Optional[DurationInSecondsOptional] = Optional.Absent,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    decisionTaskCompletedEventId: EventId,
    heartbeatTimeout: Optional[DurationInSecondsOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes = {
    import ActivityTaskScheduledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
      .builder()
      .activityType(activityType.buildAwsValue())
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(
        scheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToStartTimeout)
      .optionallyWith(
        scheduleToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToCloseTimeout)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .optionallyWith(
        heartbeatTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.heartbeatTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskScheduledEventAttributes.wrap(buildAwsValue())
}
object ActivityTaskScheduledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTaskScheduledEventAttributes =
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes(
        activityType.asEditable,
        activityId,
        input.map(value => value),
        control.map(value => value),
        scheduleToStartTimeout.map(value => value),
        scheduleToCloseTimeout.map(value => value),
        startToCloseTimeout.map(value => value),
        taskList.asEditable,
        taskPriority.map(value => value),
        decisionTaskCompletedEventId,
        heartbeatTimeout.map(value => value)
      )
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def activityId: ActivityId
    def input: Optional[Data]
    def control: Optional[Data]
    def scheduleToStartTimeout: Optional[DurationInSecondsOptional]
    def scheduleToCloseTimeout: Optional[DurationInSecondsOptional]
    def startToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Optional[TaskPriority]
    def decisionTaskCompletedEventId: EventId
    def heartbeatTimeout: Optional[DurationInSecondsOptional]
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToStartTimeout", scheduleToStartTimeout)
    def getScheduleToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToCloseTimeout", scheduleToCloseTimeout)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getHeartbeatTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("heartbeatTimeout", heartbeatTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly {
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val control: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleToStartTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val scheduleToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val startToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val heartbeatTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.heartbeatTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
  ): zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
