package zio.aws.swf.model
import zio.aws.swf.model.primitives.{EventId, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class HistoryEvent(
    eventTimestamp: Timestamp,
    eventType: zio.aws.swf.model.EventType,
    eventId: EventId,
    workflowExecutionStartedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes
    ] = Optional.Absent,
    workflowExecutionCompletedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes
    ] = Optional.Absent,
    completeWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    workflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    failWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    workflowExecutionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes
    ] = Optional.Absent,
    workflowExecutionCanceledEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes
    ] = Optional.Absent,
    cancelWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    workflowExecutionContinuedAsNewEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
    ] = Optional.Absent,
    continueAsNewWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    workflowExecutionTerminatedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes
    ] = Optional.Absent,
    workflowExecutionCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes
    ] = Optional.Absent,
    decisionTaskScheduledEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes
    ] = Optional.Absent,
    decisionTaskStartedEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskStartedEventAttributes
    ] = Optional.Absent,
    decisionTaskCompletedEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes
    ] = Optional.Absent,
    decisionTaskTimedOutEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes
    ] = Optional.Absent,
    activityTaskScheduledEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes
    ] = Optional.Absent,
    activityTaskStartedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskStartedEventAttributes
    ] = Optional.Absent,
    activityTaskCompletedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes
    ] = Optional.Absent,
    activityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskFailedEventAttributes
    ] = Optional.Absent,
    activityTaskTimedOutEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes
    ] = Optional.Absent,
    activityTaskCanceledEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes
    ] = Optional.Absent,
    activityTaskCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes
    ] = Optional.Absent,
    workflowExecutionSignaledEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes
    ] = Optional.Absent,
    markerRecordedEventAttributes: Optional[
      zio.aws.swf.model.MarkerRecordedEventAttributes
    ] = Optional.Absent,
    recordMarkerFailedEventAttributes: Optional[
      zio.aws.swf.model.RecordMarkerFailedEventAttributes
    ] = Optional.Absent,
    timerStartedEventAttributes: Optional[
      zio.aws.swf.model.TimerStartedEventAttributes
    ] = Optional.Absent,
    timerFiredEventAttributes: Optional[
      zio.aws.swf.model.TimerFiredEventAttributes
    ] = Optional.Absent,
    timerCanceledEventAttributes: Optional[
      zio.aws.swf.model.TimerCanceledEventAttributes
    ] = Optional.Absent,
    startChildWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
    ] = Optional.Absent,
    childWorkflowExecutionStartedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes
    ] = Optional.Absent,
    childWorkflowExecutionCompletedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes
    ] = Optional.Absent,
    childWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    childWorkflowExecutionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
    ] = Optional.Absent,
    childWorkflowExecutionCanceledEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes
    ] = Optional.Absent,
    childWorkflowExecutionTerminatedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
    ] = Optional.Absent,
    signalExternalWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
    ] = Optional.Absent,
    externalWorkflowExecutionSignaledEventAttributes: Optional[
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes
    ] = Optional.Absent,
    signalExternalWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    externalWorkflowExecutionCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
    ] = Optional.Absent,
    requestCancelExternalWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
    ] = Optional.Absent,
    requestCancelExternalWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    scheduleActivityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes
    ] = Optional.Absent,
    requestCancelActivityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes
    ] = Optional.Absent,
    startTimerFailedEventAttributes: Optional[
      zio.aws.swf.model.StartTimerFailedEventAttributes
    ] = Optional.Absent,
    cancelTimerFailedEventAttributes: Optional[
      zio.aws.swf.model.CancelTimerFailedEventAttributes
    ] = Optional.Absent,
    startChildWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes
    ] = Optional.Absent,
    lambdaFunctionScheduledEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes
    ] = Optional.Absent,
    lambdaFunctionStartedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes
    ] = Optional.Absent,
    lambdaFunctionCompletedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes
    ] = Optional.Absent,
    lambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes
    ] = Optional.Absent,
    lambdaFunctionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes
    ] = Optional.Absent,
    scheduleLambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes
    ] = Optional.Absent,
    startLambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.HistoryEvent = {
    import HistoryEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.HistoryEvent
      .builder()
      .eventTimestamp(Timestamp.unwrap(eventTimestamp): Instant)
      .eventType(eventType.unwrap)
      .eventId(EventId.unwrap(eventId): java.lang.Long)
      .optionallyWith(
        workflowExecutionStartedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionStartedEventAttributes)
      .optionallyWith(
        workflowExecutionCompletedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionCompletedEventAttributes)
      .optionallyWith(
        completeWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.completeWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionFailedEventAttributes)
      .optionallyWith(
        failWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.failWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionTimedOutEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionTimedOutEventAttributes)
      .optionallyWith(
        workflowExecutionCanceledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionCanceledEventAttributes)
      .optionallyWith(
        cancelWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.cancelWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionContinuedAsNewEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionContinuedAsNewEventAttributes)
      .optionallyWith(
        continueAsNewWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.continueAsNewWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionTerminatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionTerminatedEventAttributes)
      .optionallyWith(
        workflowExecutionCancelRequestedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionCancelRequestedEventAttributes)
      .optionallyWith(
        decisionTaskScheduledEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskScheduledEventAttributes)
      .optionallyWith(
        decisionTaskStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskStartedEventAttributes)
      .optionallyWith(
        decisionTaskCompletedEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskCompletedEventAttributes)
      .optionallyWith(
        decisionTaskTimedOutEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskTimedOutEventAttributes)
      .optionallyWith(
        activityTaskScheduledEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskScheduledEventAttributes)
      .optionallyWith(
        activityTaskStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskStartedEventAttributes)
      .optionallyWith(
        activityTaskCompletedEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskCompletedEventAttributes)
      .optionallyWith(
        activityTaskFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskFailedEventAttributes)
      .optionallyWith(
        activityTaskTimedOutEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskTimedOutEventAttributes)
      .optionallyWith(
        activityTaskCanceledEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskCanceledEventAttributes)
      .optionallyWith(
        activityTaskCancelRequestedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.activityTaskCancelRequestedEventAttributes)
      .optionallyWith(
        workflowExecutionSignaledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionSignaledEventAttributes)
      .optionallyWith(
        markerRecordedEventAttributes.map(value => value.buildAwsValue())
      )(_.markerRecordedEventAttributes)
      .optionallyWith(
        recordMarkerFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.recordMarkerFailedEventAttributes)
      .optionallyWith(
        timerStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.timerStartedEventAttributes)
      .optionallyWith(
        timerFiredEventAttributes.map(value => value.buildAwsValue())
      )(_.timerFiredEventAttributes)
      .optionallyWith(
        timerCanceledEventAttributes.map(value => value.buildAwsValue())
      )(_.timerCanceledEventAttributes)
      .optionallyWith(
        startChildWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startChildWorkflowExecutionInitiatedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionStartedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionStartedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionCompletedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionCompletedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionTimedOutEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionTimedOutEventAttributes)
      .optionallyWith(
        childWorkflowExecutionCanceledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionCanceledEventAttributes)
      .optionallyWith(
        childWorkflowExecutionTerminatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionTerminatedEventAttributes)
      .optionallyWith(
        signalExternalWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.signalExternalWorkflowExecutionInitiatedEventAttributes)
      .optionallyWith(
        externalWorkflowExecutionSignaledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.externalWorkflowExecutionSignaledEventAttributes)
      .optionallyWith(
        signalExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.signalExternalWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        externalWorkflowExecutionCancelRequestedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.externalWorkflowExecutionCancelRequestedEventAttributes)
      .optionallyWith(
        requestCancelExternalWorkflowExecutionInitiatedEventAttributes.map(
          value => value.buildAwsValue()
        )
      )(_.requestCancelExternalWorkflowExecutionInitiatedEventAttributes)
      .optionallyWith(
        requestCancelExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelExternalWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        scheduleActivityTaskFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleActivityTaskFailedEventAttributes)
      .optionallyWith(
        requestCancelActivityTaskFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelActivityTaskFailedEventAttributes)
      .optionallyWith(
        startTimerFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.startTimerFailedEventAttributes)
      .optionallyWith(
        cancelTimerFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.cancelTimerFailedEventAttributes)
      .optionallyWith(
        startChildWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startChildWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        lambdaFunctionScheduledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionScheduledEventAttributes)
      .optionallyWith(
        lambdaFunctionStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.lambdaFunctionStartedEventAttributes)
      .optionallyWith(
        lambdaFunctionCompletedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionCompletedEventAttributes)
      .optionallyWith(
        lambdaFunctionFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.lambdaFunctionFailedEventAttributes)
      .optionallyWith(
        lambdaFunctionTimedOutEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionTimedOutEventAttributes)
      .optionallyWith(
        scheduleLambdaFunctionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleLambdaFunctionFailedEventAttributes)
      .optionallyWith(
        startLambdaFunctionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startLambdaFunctionFailedEventAttributes)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.HistoryEvent.ReadOnly =
    zio.aws.swf.model.HistoryEvent.wrap(buildAwsValue())
}
object HistoryEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.HistoryEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.HistoryEvent =
      zio.aws.swf.model.HistoryEvent(
        eventTimestamp,
        eventType,
        eventId,
        workflowExecutionStartedEventAttributes.map(value => value.asEditable),
        workflowExecutionCompletedEventAttributes.map(value =>
          value.asEditable
        ),
        completeWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionFailedEventAttributes.map(value => value.asEditable),
        failWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionTimedOutEventAttributes.map(value => value.asEditable),
        workflowExecutionCanceledEventAttributes.map(value => value.asEditable),
        cancelWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionContinuedAsNewEventAttributes.map(value =>
          value.asEditable
        ),
        continueAsNewWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionTerminatedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionCancelRequestedEventAttributes.map(value =>
          value.asEditable
        ),
        decisionTaskScheduledEventAttributes.map(value => value.asEditable),
        decisionTaskStartedEventAttributes.map(value => value.asEditable),
        decisionTaskCompletedEventAttributes.map(value => value.asEditable),
        decisionTaskTimedOutEventAttributes.map(value => value.asEditable),
        activityTaskScheduledEventAttributes.map(value => value.asEditable),
        activityTaskStartedEventAttributes.map(value => value.asEditable),
        activityTaskCompletedEventAttributes.map(value => value.asEditable),
        activityTaskFailedEventAttributes.map(value => value.asEditable),
        activityTaskTimedOutEventAttributes.map(value => value.asEditable),
        activityTaskCanceledEventAttributes.map(value => value.asEditable),
        activityTaskCancelRequestedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionSignaledEventAttributes.map(value => value.asEditable),
        markerRecordedEventAttributes.map(value => value.asEditable),
        recordMarkerFailedEventAttributes.map(value => value.asEditable),
        timerStartedEventAttributes.map(value => value.asEditable),
        timerFiredEventAttributes.map(value => value.asEditable),
        timerCanceledEventAttributes.map(value => value.asEditable),
        startChildWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionStartedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionCompletedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionTimedOutEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionCanceledEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionTerminatedEventAttributes.map(value =>
          value.asEditable
        ),
        signalExternalWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.asEditable
        ),
        externalWorkflowExecutionSignaledEventAttributes.map(value =>
          value.asEditable
        ),
        signalExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        externalWorkflowExecutionCancelRequestedEventAttributes.map(value =>
          value.asEditable
        ),
        requestCancelExternalWorkflowExecutionInitiatedEventAttributes.map(
          value => value.asEditable
        ),
        requestCancelExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        scheduleActivityTaskFailedEventAttributes.map(value =>
          value.asEditable
        ),
        requestCancelActivityTaskFailedEventAttributes.map(value =>
          value.asEditable
        ),
        startTimerFailedEventAttributes.map(value => value.asEditable),
        cancelTimerFailedEventAttributes.map(value => value.asEditable),
        startChildWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        lambdaFunctionScheduledEventAttributes.map(value => value.asEditable),
        lambdaFunctionStartedEventAttributes.map(value => value.asEditable),
        lambdaFunctionCompletedEventAttributes.map(value => value.asEditable),
        lambdaFunctionFailedEventAttributes.map(value => value.asEditable),
        lambdaFunctionTimedOutEventAttributes.map(value => value.asEditable),
        scheduleLambdaFunctionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        startLambdaFunctionFailedEventAttributes.map(value => value.asEditable)
      )
    def eventTimestamp: Timestamp
    def eventType: zio.aws.swf.model.EventType
    def eventId: EventId
    def workflowExecutionStartedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly
    ]
    def workflowExecutionCompletedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly
    ]
    def completeWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def failWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly
    ]
    def workflowExecutionCanceledEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly
    ]
    def cancelWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionContinuedAsNewEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly
    ]
    def continueAsNewWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionTerminatedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly
    ]
    def workflowExecutionCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ]
    def decisionTaskScheduledEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly
    ]
    def decisionTaskStartedEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly
    ]
    def decisionTaskCompletedEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly
    ]
    def decisionTaskTimedOutEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly
    ]
    def activityTaskScheduledEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly
    ]
    def activityTaskStartedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskStartedEventAttributes.ReadOnly
    ]
    def activityTaskCompletedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly
    ]
    def activityTaskFailedEventAttributes
        : Optional[zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly]
    def activityTaskTimedOutEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly
    ]
    def activityTaskCanceledEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly
    ]
    def activityTaskCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly
    ]
    def workflowExecutionSignaledEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly
    ]
    def markerRecordedEventAttributes
        : Optional[zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly]
    def recordMarkerFailedEventAttributes
        : Optional[zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly]
    def timerStartedEventAttributes
        : Optional[zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly]
    def timerFiredEventAttributes
        : Optional[zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly]
    def timerCanceledEventAttributes
        : Optional[zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly]
    def startChildWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionStartedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionCompletedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionCanceledEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionTerminatedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly
    ]
    def signalExternalWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ]
    def externalWorkflowExecutionSignaledEventAttributes: Optional[
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.ReadOnly
    ]
    def signalExternalWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def externalWorkflowExecutionCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ]
    def requestCancelExternalWorkflowExecutionInitiatedEventAttributes
        : Optional[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
        ]
    def requestCancelExternalWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def scheduleActivityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly
    ]
    def requestCancelActivityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly
    ]
    def startTimerFailedEventAttributes
        : Optional[zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly]
    def cancelTimerFailedEventAttributes
        : Optional[zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly]
    def startChildWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def lambdaFunctionScheduledEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly
    ]
    def lambdaFunctionStartedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly
    ]
    def lambdaFunctionCompletedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly
    ]
    def lambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes.ReadOnly
    ]
    def lambdaFunctionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly
    ]
    def scheduleLambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly
    ]
    def startLambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly
    ]
    def getEventTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(eventTimestamp)
    def getEventType: ZIO[Any, Nothing, zio.aws.swf.model.EventType] =
      ZIO.succeed(eventType)
    def getEventId: ZIO[Any, Nothing, EventId] = ZIO.succeed(eventId)
    def getWorkflowExecutionStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionStartedEventAttributes",
      workflowExecutionStartedEventAttributes
    )
    def getWorkflowExecutionCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionCompletedEventAttributes",
      workflowExecutionCompletedEventAttributes
    )
    def getCompleteWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "completeWorkflowExecutionFailedEventAttributes",
      completeWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionFailedEventAttributes",
      workflowExecutionFailedEventAttributes
    )
    def getFailWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "failWorkflowExecutionFailedEventAttributes",
      failWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionTimedOutEventAttributes",
      workflowExecutionTimedOutEventAttributes
    )
    def getWorkflowExecutionCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionCanceledEventAttributes",
      workflowExecutionCanceledEventAttributes
    )
    def getCancelWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelWorkflowExecutionFailedEventAttributes",
      cancelWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionContinuedAsNewEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionContinuedAsNewEventAttributes",
      workflowExecutionContinuedAsNewEventAttributes
    )
    def getContinueAsNewWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continueAsNewWorkflowExecutionFailedEventAttributes",
      continueAsNewWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionTerminatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionTerminatedEventAttributes",
      workflowExecutionTerminatedEventAttributes
    )
    def getWorkflowExecutionCancelRequestedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionCancelRequestedEventAttributes",
      workflowExecutionCancelRequestedEventAttributes
    )
    def getDecisionTaskScheduledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskScheduledEventAttributes",
      decisionTaskScheduledEventAttributes
    )
    def getDecisionTaskStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskStartedEventAttributes",
      decisionTaskStartedEventAttributes
    )
    def getDecisionTaskCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskCompletedEventAttributes",
      decisionTaskCompletedEventAttributes
    )
    def getDecisionTaskTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskTimedOutEventAttributes",
      decisionTaskTimedOutEventAttributes
    )
    def getActivityTaskScheduledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskScheduledEventAttributes",
      activityTaskScheduledEventAttributes
    )
    def getActivityTaskStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskStartedEventAttributes",
      activityTaskStartedEventAttributes
    )
    def getActivityTaskCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskCompletedEventAttributes",
      activityTaskCompletedEventAttributes
    )
    def getActivityTaskFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskFailedEventAttributes",
      activityTaskFailedEventAttributes
    )
    def getActivityTaskTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskTimedOutEventAttributes",
      activityTaskTimedOutEventAttributes
    )
    def getActivityTaskCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskCanceledEventAttributes",
      activityTaskCanceledEventAttributes
    )
    def getActivityTaskCancelRequestedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskCancelRequestedEventAttributes",
      activityTaskCancelRequestedEventAttributes
    )
    def getWorkflowExecutionSignaledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionSignaledEventAttributes",
      workflowExecutionSignaledEventAttributes
    )
    def getMarkerRecordedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "markerRecordedEventAttributes",
      markerRecordedEventAttributes
    )
    def getRecordMarkerFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordMarkerFailedEventAttributes",
      recordMarkerFailedEventAttributes
    )
    def getTimerStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timerStartedEventAttributes",
      timerStartedEventAttributes
    )
    def getTimerFiredEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timerFiredEventAttributes",
      timerFiredEventAttributes
    )
    def getTimerCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timerCanceledEventAttributes",
      timerCanceledEventAttributes
    )
    def getStartChildWorkflowExecutionInitiatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startChildWorkflowExecutionInitiatedEventAttributes",
      startChildWorkflowExecutionInitiatedEventAttributes
    )
    def getChildWorkflowExecutionStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionStartedEventAttributes",
      childWorkflowExecutionStartedEventAttributes
    )
    def getChildWorkflowExecutionCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionCompletedEventAttributes",
      childWorkflowExecutionCompletedEventAttributes
    )
    def getChildWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionFailedEventAttributes",
      childWorkflowExecutionFailedEventAttributes
    )
    def getChildWorkflowExecutionTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionTimedOutEventAttributes",
      childWorkflowExecutionTimedOutEventAttributes
    )
    def getChildWorkflowExecutionCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionCanceledEventAttributes",
      childWorkflowExecutionCanceledEventAttributes
    )
    def getChildWorkflowExecutionTerminatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionTerminatedEventAttributes",
      childWorkflowExecutionTerminatedEventAttributes
    )
    def getSignalExternalWorkflowExecutionInitiatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signalExternalWorkflowExecutionInitiatedEventAttributes",
      signalExternalWorkflowExecutionInitiatedEventAttributes
    )
    def getExternalWorkflowExecutionSignaledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalWorkflowExecutionSignaledEventAttributes",
      externalWorkflowExecutionSignaledEventAttributes
    )
    def getSignalExternalWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signalExternalWorkflowExecutionFailedEventAttributes",
      signalExternalWorkflowExecutionFailedEventAttributes
    )
    def getExternalWorkflowExecutionCancelRequestedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalWorkflowExecutionCancelRequestedEventAttributes",
      externalWorkflowExecutionCancelRequestedEventAttributes
    )
    def getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelExternalWorkflowExecutionInitiatedEventAttributes",
      requestCancelExternalWorkflowExecutionInitiatedEventAttributes
    )
    def getRequestCancelExternalWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelExternalWorkflowExecutionFailedEventAttributes",
      requestCancelExternalWorkflowExecutionFailedEventAttributes
    )
    def getScheduleActivityTaskFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleActivityTaskFailedEventAttributes",
      scheduleActivityTaskFailedEventAttributes
    )
    def getRequestCancelActivityTaskFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelActivityTaskFailedEventAttributes",
      requestCancelActivityTaskFailedEventAttributes
    )
    def getStartTimerFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startTimerFailedEventAttributes",
      startTimerFailedEventAttributes
    )
    def getCancelTimerFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelTimerFailedEventAttributes",
      cancelTimerFailedEventAttributes
    )
    def getStartChildWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startChildWorkflowExecutionFailedEventAttributes",
      startChildWorkflowExecutionFailedEventAttributes
    )
    def getLambdaFunctionScheduledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionScheduledEventAttributes",
      lambdaFunctionScheduledEventAttributes
    )
    def getLambdaFunctionStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionStartedEventAttributes",
      lambdaFunctionStartedEventAttributes
    )
    def getLambdaFunctionCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionCompletedEventAttributes",
      lambdaFunctionCompletedEventAttributes
    )
    def getLambdaFunctionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionFailedEventAttributes",
      lambdaFunctionFailedEventAttributes
    )
    def getLambdaFunctionTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionTimedOutEventAttributes",
      lambdaFunctionTimedOutEventAttributes
    )
    def getScheduleLambdaFunctionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleLambdaFunctionFailedEventAttributes",
      scheduleLambdaFunctionFailedEventAttributes
    )
    def getStartLambdaFunctionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startLambdaFunctionFailedEventAttributes",
      startLambdaFunctionFailedEventAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.HistoryEvent
  ) extends zio.aws.swf.model.HistoryEvent.ReadOnly {
    override val eventTimestamp: Timestamp =
      zio.aws.swf.model.primitives.Timestamp(impl.eventTimestamp())
    override val eventType: zio.aws.swf.model.EventType =
      zio.aws.swf.model.EventType.wrap(impl.eventType())
    override val eventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.eventId())
    override val workflowExecutionStartedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.wrap(value)
      )
    override val workflowExecutionCompletedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.wrap(value)
      )
    override val completeWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.completeWorkflowExecutionFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val workflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.wrap(value)
      )
    override val failWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.wrap(value)
      )
    override val workflowExecutionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.wrap(value)
      )
    override val workflowExecutionCanceledEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionCanceledEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.wrap(value)
      )
    override val cancelWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val workflowExecutionContinuedAsNewEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.workflowExecutionContinuedAsNewEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
          .wrap(value)
      )
    override val continueAsNewWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.continueAsNewWorkflowExecutionFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val workflowExecutionTerminatedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionTerminatedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.wrap(value)
      )
    override val workflowExecutionCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.workflowExecutionCancelRequestedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes
          .wrap(value)
      )
    override val decisionTaskScheduledEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.decisionTaskScheduledEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskScheduledEventAttributes.wrap(value)
      )
    override val decisionTaskStartedEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.decisionTaskStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskStartedEventAttributes.wrap(value)
      )
    override val decisionTaskCompletedEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.decisionTaskCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskCompletedEventAttributes.wrap(value)
      )
    override val decisionTaskTimedOutEventAttributes: Optional[
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.decisionTaskTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.wrap(value)
      )
    override val activityTaskScheduledEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskScheduledEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskScheduledEventAttributes.wrap(value)
      )
    override val activityTaskStartedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskStartedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskStartedEventAttributes.wrap(value)
      )
    override val activityTaskCompletedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskCompletedEventAttributes.wrap(value)
      )
    override val activityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskFailedEventAttributes.wrap(value)
      )
    override val activityTaskTimedOutEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.wrap(value)
      )
    override val activityTaskCanceledEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskCanceledEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskCanceledEventAttributes.wrap(value)
      )
    override val activityTaskCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityTaskCancelRequestedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.wrap(value)
      )
    override val workflowExecutionSignaledEventAttributes: Optional[
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutionSignaledEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.wrap(value)
      )
    override val markerRecordedEventAttributes
        : Optional[zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.markerRecordedEventAttributes())
        .map(value =>
          zio.aws.swf.model.MarkerRecordedEventAttributes.wrap(value)
        )
    override val recordMarkerFailedEventAttributes: Optional[
      zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recordMarkerFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.RecordMarkerFailedEventAttributes.wrap(value)
      )
    override val timerStartedEventAttributes
        : Optional[zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timerStartedEventAttributes())
        .map(value => zio.aws.swf.model.TimerStartedEventAttributes.wrap(value))
    override val timerFiredEventAttributes
        : Optional[zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timerFiredEventAttributes())
        .map(value => zio.aws.swf.model.TimerFiredEventAttributes.wrap(value))
    override val timerCanceledEventAttributes
        : Optional[zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timerCanceledEventAttributes())
        .map(value =>
          zio.aws.swf.model.TimerCanceledEventAttributes.wrap(value)
        )
    override val startChildWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.startChildWorkflowExecutionInitiatedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionStartedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.childWorkflowExecutionStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionCompletedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.childWorkflowExecutionCompletedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.childWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.childWorkflowExecutionTimedOutEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionCanceledEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.childWorkflowExecutionCanceledEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionTerminatedEventAttributes: Optional[
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.childWorkflowExecutionTerminatedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
          .wrap(value)
      )
    override val signalExternalWorkflowExecutionInitiatedEventAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.signalExternalWorkflowExecutionInitiatedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
          .wrap(value)
      )
    override val externalWorkflowExecutionSignaledEventAttributes: Optional[
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.externalWorkflowExecutionSignaledEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes
          .wrap(value)
      )
    override val signalExternalWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.signalExternalWorkflowExecutionFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val externalWorkflowExecutionCancelRequestedEventAttributes: Optional[
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.externalWorkflowExecutionCancelRequestedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
          .wrap(value)
      )
    override val requestCancelExternalWorkflowExecutionInitiatedEventAttributes
        : Optional[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.requestCancelExternalWorkflowExecutionInitiatedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
          .wrap(value)
      )
    override val requestCancelExternalWorkflowExecutionFailedEventAttributes
        : Optional[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ReadOnly
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.requestCancelExternalWorkflowExecutionFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val scheduleActivityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleActivityTaskFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.wrap(value)
      )
    override val requestCancelActivityTaskFailedEventAttributes: Optional[
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.requestCancelActivityTaskFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes
          .wrap(value)
      )
    override val startTimerFailedEventAttributes
        : Optional[zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimerFailedEventAttributes())
        .map(value =>
          zio.aws.swf.model.StartTimerFailedEventAttributes.wrap(value)
        )
    override val cancelTimerFailedEventAttributes: Optional[
      zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelTimerFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.CancelTimerFailedEventAttributes.wrap(value)
      )
    override val startChildWorkflowExecutionFailedEventAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.startChildWorkflowExecutionFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val lambdaFunctionScheduledEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionScheduledEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.wrap(value)
      )
    override val lambdaFunctionStartedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionStartedEventAttributes.wrap(value)
      )
    override val lambdaFunctionCompletedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.wrap(value)
      )
    override val lambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionFailedEventAttributes.wrap(value)
      )
    override val lambdaFunctionTimedOutEventAttributes: Optional[
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.wrap(value)
      )
    override val scheduleLambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleLambdaFunctionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes
          .wrap(value)
      )
    override val startLambdaFunctionFailedEventAttributes: Optional[
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.startLambdaFunctionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.HistoryEvent
  ): zio.aws.swf.model.HistoryEvent.ReadOnly = new Wrapper(impl)
}
