package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait DecisionType {
  def unwrap: software.amazon.awssdk.services.swf.model.DecisionType
}
object DecisionType {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.DecisionType
  ): zio.aws.swf.model.DecisionType = value match {
    case software.amazon.awssdk.services.swf.model.DecisionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.SCHEDULE_ACTIVITY_TASK =>
      val r = ScheduleActivityTask
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.REQUEST_CANCEL_ACTIVITY_TASK =>
      val r = RequestCancelActivityTask
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.COMPLETE_WORKFLOW_EXECUTION =>
      val r = CompleteWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.FAIL_WORKFLOW_EXECUTION =>
      val r = FailWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.CANCEL_WORKFLOW_EXECUTION =>
      val r = CancelWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.CONTINUE_AS_NEW_WORKFLOW_EXECUTION =>
      val r = ContinueAsNewWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.RECORD_MARKER =>
      val r = RecordMarker
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.START_TIMER =>
      val r = StartTimer
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.CANCEL_TIMER =>
      val r = CancelTimer
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION =>
      val r = SignalExternalWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION =>
      val r = RequestCancelExternalWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.START_CHILD_WORKFLOW_EXECUTION =>
      val r = StartChildWorkflowExecution
      r
    case software.amazon.awssdk.services.swf.model.DecisionType.SCHEDULE_LAMBDA_FUNCTION =>
      val r = ScheduleLambdaFunction
      r
  }
  case object unknownToSdkVersion extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ScheduleActivityTask extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.SCHEDULE_ACTIVITY_TASK
  }
  case object RequestCancelActivityTask extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.REQUEST_CANCEL_ACTIVITY_TASK
  }
  case object CompleteWorkflowExecution extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.COMPLETE_WORKFLOW_EXECUTION
  }
  case object FailWorkflowExecution extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.FAIL_WORKFLOW_EXECUTION
  }
  case object CancelWorkflowExecution extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.CANCEL_WORKFLOW_EXECUTION
  }
  case object ContinueAsNewWorkflowExecution
      extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.CONTINUE_AS_NEW_WORKFLOW_EXECUTION
  }
  case object RecordMarker extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.RECORD_MARKER
  }
  case object StartTimer extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.START_TIMER
  }
  case object CancelTimer extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.CANCEL_TIMER
  }
  case object SignalExternalWorkflowExecution
      extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION
  }
  case object RequestCancelExternalWorkflowExecution
      extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION
  }
  case object StartChildWorkflowExecution
      extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.START_CHILD_WORKFLOW_EXECUTION
  }
  case object ScheduleLambdaFunction extends zio.aws.swf.model.DecisionType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionType =
      software.amazon.awssdk.services.swf.model.DecisionType.SCHEDULE_LAMBDA_FUNCTION
  }
}
