package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  DomainName,
  Description,
  Version,
  DurationInSecondsOptional,
  Name
}
import scala.jdk.CollectionConverters._
final case class RegisterActivityTypeRequest(
    domain: DomainName,
    name: Name,
    version: Version,
    description: Optional[Description] = Optional.Absent,
    defaultTaskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    defaultTaskHeartbeatTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    defaultTaskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    defaultTaskPriority: Optional[TaskPriority] = Optional.Absent,
    defaultTaskScheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    defaultTaskScheduleToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest = {
    import RegisterActivityTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        defaultTaskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultTaskStartToCloseTimeout)
      .optionallyWith(
        defaultTaskHeartbeatTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultTaskHeartbeatTimeout)
      .optionallyWith(defaultTaskList.map(value => value.buildAwsValue()))(
        _.defaultTaskList
      )
      .optionallyWith(
        defaultTaskPriority.map(value =>
          TaskPriority.unwrap(value): java.lang.String
        )
      )(_.defaultTaskPriority)
      .optionallyWith(
        defaultTaskScheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultTaskScheduleToStartTimeout)
      .optionallyWith(
        defaultTaskScheduleToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultTaskScheduleToCloseTimeout)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.RegisterActivityTypeRequest.ReadOnly =
    zio.aws.swf.model.RegisterActivityTypeRequest.wrap(buildAwsValue())
}
object RegisterActivityTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RegisterActivityTypeRequest =
      zio.aws.swf.model.RegisterActivityTypeRequest(
        domain,
        name,
        version,
        description.map(value => value),
        defaultTaskStartToCloseTimeout.map(value => value),
        defaultTaskHeartbeatTimeout.map(value => value),
        defaultTaskList.map(value => value.asEditable),
        defaultTaskPriority.map(value => value),
        defaultTaskScheduleToStartTimeout.map(value => value),
        defaultTaskScheduleToCloseTimeout.map(value => value)
      )
    def domain: DomainName
    def name: Name
    def version: Version
    def description: Optional[Description]
    def defaultTaskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def defaultTaskHeartbeatTimeout: Optional[DurationInSecondsOptional]
    def defaultTaskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def defaultTaskPriority: Optional[TaskPriority]
    def defaultTaskScheduleToStartTimeout: Optional[DurationInSecondsOptional]
    def defaultTaskScheduleToCloseTimeout: Optional[DurationInSecondsOptional]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultTaskStartToCloseTimeout",
        defaultTaskStartToCloseTimeout
      )
    def getDefaultTaskHeartbeatTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultTaskHeartbeatTimeout",
        defaultTaskHeartbeatTimeout
      )
    def getDefaultTaskList
        : ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("defaultTaskList", defaultTaskList)
    def getDefaultTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("defaultTaskPriority", defaultTaskPriority)
    def getDefaultTaskScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultTaskScheduleToStartTimeout",
        defaultTaskScheduleToStartTimeout
      )
    def getDefaultTaskScheduleToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultTaskScheduleToCloseTimeout",
        defaultTaskScheduleToCloseTimeout
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest
  ) extends zio.aws.swf.model.RegisterActivityTypeRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val name: Name = zio.aws.swf.model.primitives.Name(impl.name())
    override val version: Version =
      zio.aws.swf.model.primitives.Version(impl.version())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.swf.model.primitives.Description(value))
    override val defaultTaskStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultTaskHeartbeatTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskHeartbeatTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultTaskList
        : Optional[zio.aws.swf.model.TaskList.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskList())
      .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val defaultTaskPriority: Optional[TaskPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTaskPriority())
        .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val defaultTaskScheduleToStartTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskScheduleToStartTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultTaskScheduleToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskScheduleToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest
  ): zio.aws.swf.model.RegisterActivityTypeRequest.ReadOnly = new Wrapper(impl)
}
