package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  WorkflowRunIdOptional,
  WorkflowId,
  DomainName
}
import scala.jdk.CollectionConverters._
final case class RequestCancelWorkflowExecutionRequest(
    domain: DomainName,
    workflowId: WorkflowId,
    runId: Optional[WorkflowRunIdOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest = {
    import RequestCancelWorkflowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RequestCancelWorkflowExecutionRequest.ReadOnly =
    zio.aws.swf.model.RequestCancelWorkflowExecutionRequest
      .wrap(buildAwsValue())
}
object RequestCancelWorkflowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RequestCancelWorkflowExecutionRequest =
      zio.aws.swf.model.RequestCancelWorkflowExecutionRequest(
        domain,
        workflowId,
        runId.map(value => value)
      )
    def domain: DomainName
    def workflowId: WorkflowId
    def runId: Optional[WorkflowRunIdOptional]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest
  ) extends zio.aws.swf.model.RequestCancelWorkflowExecutionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Optional[WorkflowRunIdOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest
  ): zio.aws.swf.model.RequestCancelWorkflowExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
