package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class UndeprecateDomainRequest(name: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest = {
    import UndeprecateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest
      .builder()
      .name(DomainName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.UndeprecateDomainRequest.ReadOnly =
    zio.aws.swf.model.UndeprecateDomainRequest.wrap(buildAwsValue())
}
object UndeprecateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.UndeprecateDomainRequest =
      zio.aws.swf.model.UndeprecateDomainRequest(name)
    def name: DomainName
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest
  ) extends zio.aws.swf.model.UndeprecateDomainRequest.ReadOnly {
    override val name: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest
  ): zio.aws.swf.model.UndeprecateDomainRequest.ReadOnly = new Wrapper(impl)
}
