package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DescribeDomainRequest(name: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeDomainRequest = {
    import DescribeDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeDomainRequest
      .builder()
      .name(DomainName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeDomainRequest.ReadOnly =
    zio.aws.swf.model.DescribeDomainRequest.wrap(buildAwsValue())
}
object DescribeDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeDomainRequest =
      zio.aws.swf.model.DescribeDomainRequest(name)
    def name: DomainName
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeDomainRequest
  ) extends zio.aws.swf.model.DescribeDomainRequest.ReadOnly {
    override val name: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeDomainRequest
  ): zio.aws.swf.model.DescribeDomainRequest.ReadOnly = new Wrapper(impl)
}
