package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListWorkflowTypesResponse(
    typeInfos: Iterable[zio.aws.swf.model.WorkflowTypeInfo],
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse = {
    import ListWorkflowTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse
      .builder()
      .typeInfos(typeInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly =
    zio.aws.swf.model.ListWorkflowTypesResponse.wrap(buildAwsValue())
}
object ListWorkflowTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListWorkflowTypesResponse =
      zio.aws.swf.model.ListWorkflowTypesResponse(
        typeInfos.map { item =>
          item.asEditable
        },
        nextPageToken.map(value => value)
      )
    def typeInfos: List[zio.aws.swf.model.WorkflowTypeInfo.ReadOnly]
    def nextPageToken: Option[PageToken]
    def getTypeInfos
        : ZIO[Any, Nothing, List[zio.aws.swf.model.WorkflowTypeInfo.ReadOnly]] =
      ZIO.succeed(typeInfos)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse
  ) extends zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly {
    override val typeInfos: List[zio.aws.swf.model.WorkflowTypeInfo.ReadOnly] =
      impl
        .typeInfos()
        .asScala
        .map { item =>
          zio.aws.swf.model.WorkflowTypeInfo.wrap(item)
        }
        .toList
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse
  ): zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly = new Wrapper(impl)
}
