package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.swf.model.primitives.{Timestamp, Description}
import scala.jdk.CollectionConverters._
final case class WorkflowTypeInfo(
    workflowType: zio.aws.swf.model.WorkflowType,
    status: zio.aws.swf.model.RegistrationStatus,
    description: Option[Description] = None,
    creationDate: Timestamp,
    deprecationDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowTypeInfo = {
    import WorkflowTypeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowTypeInfo
      .builder()
      .workflowType(workflowType.buildAwsValue())
      .status(status.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .optionallyWith(
        deprecationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deprecationDate)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowTypeInfo.ReadOnly =
    zio.aws.swf.model.WorkflowTypeInfo.wrap(buildAwsValue())
}
object WorkflowTypeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowTypeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowTypeInfo =
      zio.aws.swf.model.WorkflowTypeInfo(
        workflowType.asEditable,
        status,
        description.map(value => value),
        creationDate,
        deprecationDate.map(value => value)
      )
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def status: zio.aws.swf.model.RegistrationStatus
    def description: Option[Description]
    def creationDate: Timestamp
    def deprecationDate: Option[Timestamp]
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getStatus: ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getDeprecationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowTypeInfo
  ) extends zio.aws.swf.model.WorkflowTypeInfo.ReadOnly {
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val status: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.status())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.swf.model.primitives.Description(value))
    override val creationDate: Timestamp =
      zio.aws.swf.model.primitives.Timestamp(impl.creationDate())
    override val deprecationDate: Option[Timestamp] = scala
      .Option(impl.deprecationDate())
      .map(value => zio.aws.swf.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowTypeInfo
  ): zio.aws.swf.model.WorkflowTypeInfo.ReadOnly = new Wrapper(impl)
}
