package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  Data,
  EventId,
  WorkflowRunIdOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class SignalExternalWorkflowExecutionFailedEventAttributes(
    workflowId: WorkflowId,
    runId: Option[WorkflowRunIdOptional] = None,
    cause: zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause,
    initiatedEventId: EventId,
    decisionTaskCompletedEventId: EventId,
    control: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes = {
    import SignalExternalWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .cause(cause.unwrap)
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object SignalExternalWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes(
        workflowId,
        runId.map(value => value),
        cause,
        initiatedEventId,
        decisionTaskCompletedEventId,
        control.map(value => value)
      )
    def workflowId: WorkflowId
    def runId: Option[WorkflowRunIdOptional]
    def cause: zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause
    def initiatedEventId: EventId
    def decisionTaskCompletedEventId: EventId
    def control: Option[Data]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause
    ] = ZIO.succeed(cause)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Option[WorkflowRunIdOptional] = scala
      .Option(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val cause
        : zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause =
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause
        .wrap(impl.cause())
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
