package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{EventId, Data, SignalName}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionSignaledEventAttributes(
    signalName: SignalName,
    input: Option[Data] = None,
    externalWorkflowExecution: Option[zio.aws.swf.model.WorkflowExecution] =
      None,
    externalInitiatedEventId: Option[EventId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionSignaledEventAttributes = {
    import WorkflowExecutionSignaledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionSignaledEventAttributes
      .builder()
      .signalName(SignalName.unwrap(signalName): java.lang.String)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        externalWorkflowExecution.map(value => value.buildAwsValue())
      )(_.externalWorkflowExecution)
      .optionallyWith(
        externalInitiatedEventId.map(value =>
          EventId.unwrap(value): java.lang.Long
        )
      )(_.externalInitiatedEventId)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionSignaledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionSignaledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes =
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes(
        signalName,
        input.map(value => value),
        externalWorkflowExecution.map(value => value.asEditable),
        externalInitiatedEventId.map(value => value)
      )
    def signalName: SignalName
    def input: Option[Data]
    def externalWorkflowExecution
        : Option[zio.aws.swf.model.WorkflowExecution.ReadOnly]
    def externalInitiatedEventId: Option[EventId]
    def getSignalName: ZIO[Any, Nothing, SignalName] = ZIO.succeed(signalName)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExternalWorkflowExecution
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      AwsError.unwrapOptionField(
        "externalWorkflowExecution",
        externalWorkflowExecution
      )
    def getExternalInitiatedEventId: ZIO[Any, AwsError, EventId] = AwsError
      .unwrapOptionField("externalInitiatedEventId", externalInitiatedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionSignaledEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly {
    override val signalName: SignalName =
      zio.aws.swf.model.primitives.SignalName(impl.signalName())
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val externalWorkflowExecution
        : Option[zio.aws.swf.model.WorkflowExecution.ReadOnly] = scala
      .Option(impl.externalWorkflowExecution())
      .map(value => zio.aws.swf.model.WorkflowExecution.wrap(value))
    override val externalInitiatedEventId: Option[EventId] = scala
      .Option(impl.externalInitiatedEventId())
      .map(value => zio.aws.swf.model.primitives.EventId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionSignaledEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
