package zio.aws.swf.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{OpenDecisionTasksCount, Count}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionOpenCounts(
    openActivityTasks: Count,
    openDecisionTasks: OpenDecisionTasksCount,
    openTimers: Count,
    openChildWorkflowExecutions: Count,
    openLambdaFunctions: Option[Count] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts = {
    import WorkflowExecutionOpenCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts
      .builder()
      .openActivityTasks(Count.unwrap(openActivityTasks): Integer)
      .openDecisionTasks(
        OpenDecisionTasksCount.unwrap(openDecisionTasks): Integer
      )
      .openTimers(Count.unwrap(openTimers): Integer)
      .openChildWorkflowExecutions(
        Count.unwrap(openChildWorkflowExecutions): Integer
      )
      .optionallyWith(
        openLambdaFunctions.map(value => Count.unwrap(value): Integer)
      )(_.openLambdaFunctions)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowExecutionOpenCounts.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionOpenCounts.wrap(buildAwsValue())
}
object WorkflowExecutionOpenCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionOpenCounts =
      zio.aws.swf.model.WorkflowExecutionOpenCounts(
        openActivityTasks,
        openDecisionTasks,
        openTimers,
        openChildWorkflowExecutions,
        openLambdaFunctions.map(value => value)
      )
    def openActivityTasks: Count
    def openDecisionTasks: OpenDecisionTasksCount
    def openTimers: Count
    def openChildWorkflowExecutions: Count
    def openLambdaFunctions: Option[Count]
    def getOpenActivityTasks: ZIO[Any, Nothing, Count] =
      ZIO.succeed(openActivityTasks)
    def getOpenDecisionTasks: ZIO[Any, Nothing, OpenDecisionTasksCount] =
      ZIO.succeed(openDecisionTasks)
    def getOpenTimers: ZIO[Any, Nothing, Count] = ZIO.succeed(openTimers)
    def getOpenChildWorkflowExecutions: ZIO[Any, Nothing, Count] =
      ZIO.succeed(openChildWorkflowExecutions)
    def getOpenLambdaFunctions: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("openLambdaFunctions", openLambdaFunctions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts
  ) extends zio.aws.swf.model.WorkflowExecutionOpenCounts.ReadOnly {
    override val openActivityTasks: Count =
      zio.aws.swf.model.primitives.Count(impl.openActivityTasks())
    override val openDecisionTasks: OpenDecisionTasksCount =
      zio.aws.swf.model.primitives
        .OpenDecisionTasksCount(impl.openDecisionTasks())
    override val openTimers: Count =
      zio.aws.swf.model.primitives.Count(impl.openTimers())
    override val openChildWorkflowExecutions: Count =
      zio.aws.swf.model.primitives.Count(impl.openChildWorkflowExecutions())
    override val openLambdaFunctions: Option[Count] = scala
      .Option(impl.openLambdaFunctions())
      .map(value => zio.aws.swf.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts
  ): zio.aws.swf.model.WorkflowExecutionOpenCounts.ReadOnly = new Wrapper(impl)
}
