package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{EventId, Data}
import scala.jdk.CollectionConverters._
final case class ChildWorkflowExecutionCompletedEventAttributes(
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    workflowType: zio.aws.swf.model.WorkflowType,
    result: Option[Data] = None,
    initiatedEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes = {
    import ChildWorkflowExecutionCompletedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes
      .builder()
      .workflowExecution(workflowExecution.buildAwsValue())
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        result.map(value => Data.unwrap(value): java.lang.String)
      )(_.result)
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly =
    zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes
      .wrap(buildAwsValue())
}
object ChildWorkflowExecutionCompletedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes =
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes(
        workflowExecution.asEditable,
        workflowType.asEditable,
        result.map(value => value),
        initiatedEventId,
        startedEventId
      )
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def result: Option[Data]
    def initiatedEventId: EventId
    def startedEventId: EventId
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getResult: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("result", result)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes
  ) extends zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly {
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val result: Option[Data] = scala
      .Option(impl.result())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes
  ): zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
