package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  Tag,
  Arn,
  EventId,
  DurationInSecondsOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class StartChildWorkflowExecutionInitiatedEventAttributes(
    workflowId: WorkflowId,
    workflowType: zio.aws.swf.model.WorkflowType,
    control: Option[Data] = None,
    input: Option[Data] = None,
    executionStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Option[TaskPriority] = None,
    decisionTaskCompletedEventId: EventId,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    taskStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    tagList: Option[Iterable[Tag]] = None,
    lambdaRole: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes = {
    import StartChildWorkflowExecutionInitiatedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .childPolicy(childPolicy.unwrap)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
      .wrap(buildAwsValue())
}
object StartChildWorkflowExecutionInitiatedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes =
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes(
        workflowId,
        workflowType.asEditable,
        control.map(value => value),
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        taskList.asEditable,
        taskPriority.map(value => value),
        decisionTaskCompletedEventId,
        childPolicy,
        taskStartToCloseTimeout.map(value => value),
        tagList.map(value => value),
        lambdaRole.map(value => value)
      )
    def workflowId: WorkflowId
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def control: Option[Data]
    def input: Option[Data]
    def executionStartToCloseTimeout: Option[DurationInSecondsOptional]
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Option[TaskPriority]
    def decisionTaskCompletedEventId: EventId
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def taskStartToCloseTimeout: Option[DurationInSecondsOptional]
    def tagList: Option[List[Tag]]
    def lambdaRole: Option[Arn]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
  ) extends zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Option[DurationInSecondsOptional] = scala
      .Option(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Option[TaskPriority] = scala
      .Option(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val taskStartToCloseTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val tagList: Option[List[Tag]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val lambdaRole: Option[Arn] = scala
      .Option(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
  ): zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
