package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{LimitedData, TaskToken}
import scala.jdk.CollectionConverters._
final case class RecordActivityTaskHeartbeatRequest(
    taskToken: TaskToken,
    details: Option[LimitedData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest = {
    import RecordActivityTaskHeartbeatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        details.map(value => LimitedData.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RecordActivityTaskHeartbeatRequest.ReadOnly =
    zio.aws.swf.model.RecordActivityTaskHeartbeatRequest.wrap(buildAwsValue())
}
object RecordActivityTaskHeartbeatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RecordActivityTaskHeartbeatRequest =
      zio.aws.swf.model.RecordActivityTaskHeartbeatRequest(
        taskToken,
        details.map(value => value)
      )
    def taskToken: TaskToken
    def details: Option[LimitedData]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getDetails: ZIO[Any, AwsError, LimitedData] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest
  ) extends zio.aws.swf.model.RecordActivityTaskHeartbeatRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val details: Option[LimitedData] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.LimitedData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest
  ): zio.aws.swf.model.RecordActivityTaskHeartbeatRequest.ReadOnly =
    new Wrapper(impl)
}
