package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  Arn,
  TaskPriority,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters._
final case class WorkflowTypeConfiguration(
    defaultTaskStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    defaultExecutionStartToCloseTimeout: Option[DurationInSecondsOptional] =
      None,
    defaultTaskList: Option[zio.aws.swf.model.TaskList] = None,
    defaultTaskPriority: Option[TaskPriority] = None,
    defaultChildPolicy: Option[zio.aws.swf.model.ChildPolicy] = None,
    defaultLambdaRole: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowTypeConfiguration = {
    import WorkflowTypeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowTypeConfiguration
      .builder()
      .optionallyWith(
        defaultTaskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultTaskStartToCloseTimeout)
      .optionallyWith(
        defaultExecutionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultExecutionStartToCloseTimeout)
      .optionallyWith(defaultTaskList.map(value => value.buildAwsValue()))(
        _.defaultTaskList
      )
      .optionallyWith(
        defaultTaskPriority.map(value =>
          TaskPriority.unwrap(value): java.lang.String
        )
      )(_.defaultTaskPriority)
      .optionallyWith(defaultChildPolicy.map(value => value.unwrap))(
        _.defaultChildPolicy
      )
      .optionallyWith(
        defaultLambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.defaultLambdaRole)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowTypeConfiguration.ReadOnly =
    zio.aws.swf.model.WorkflowTypeConfiguration.wrap(buildAwsValue())
}
object WorkflowTypeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowTypeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowTypeConfiguration =
      zio.aws.swf.model.WorkflowTypeConfiguration(
        defaultTaskStartToCloseTimeout.map(value => value),
        defaultExecutionStartToCloseTimeout.map(value => value),
        defaultTaskList.map(value => value.asEditable),
        defaultTaskPriority.map(value => value),
        defaultChildPolicy.map(value => value),
        defaultLambdaRole.map(value => value)
      )
    def defaultTaskStartToCloseTimeout: Option[DurationInSecondsOptional]
    def defaultExecutionStartToCloseTimeout: Option[DurationInSecondsOptional]
    def defaultTaskList: Option[zio.aws.swf.model.TaskList.ReadOnly]
    def defaultTaskPriority: Option[TaskPriority]
    def defaultChildPolicy: Option[zio.aws.swf.model.ChildPolicy]
    def defaultLambdaRole: Option[Arn]
    def getDefaultTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultTaskStartToCloseTimeout",
        defaultTaskStartToCloseTimeout
      )
    def getDefaultExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultExecutionStartToCloseTimeout",
        defaultExecutionStartToCloseTimeout
      )
    def getDefaultTaskList
        : ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("defaultTaskList", defaultTaskList)
    def getDefaultTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("defaultTaskPriority", defaultTaskPriority)
    def getDefaultChildPolicy
        : ZIO[Any, AwsError, zio.aws.swf.model.ChildPolicy] =
      AwsError.unwrapOptionField("defaultChildPolicy", defaultChildPolicy)
    def getDefaultLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("defaultLambdaRole", defaultLambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowTypeConfiguration
  ) extends zio.aws.swf.model.WorkflowTypeConfiguration.ReadOnly {
    override val defaultTaskStartToCloseTimeout
        : Option[DurationInSecondsOptional] = scala
      .Option(impl.defaultTaskStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultExecutionStartToCloseTimeout
        : Option[DurationInSecondsOptional] = scala
      .Option(impl.defaultExecutionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultTaskList: Option[zio.aws.swf.model.TaskList.ReadOnly] =
      scala
        .Option(impl.defaultTaskList())
        .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val defaultTaskPriority: Option[TaskPriority] = scala
      .Option(impl.defaultTaskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val defaultChildPolicy: Option[zio.aws.swf.model.ChildPolicy] =
      scala
        .Option(impl.defaultChildPolicy())
        .map(value => zio.aws.swf.model.ChildPolicy.wrap(value))
    override val defaultLambdaRole: Option[Arn] = scala
      .Option(impl.defaultLambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowTypeConfiguration
  ): zio.aws.swf.model.WorkflowTypeConfiguration.ReadOnly = new Wrapper(impl)
}
