package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionCancelRequestedEventAttributes(
    externalWorkflowExecution: Option[zio.aws.swf.model.WorkflowExecution] =
      None,
    externalInitiatedEventId: Option[EventId] = None,
    cause: Option[zio.aws.swf.model.WorkflowExecutionCancelRequestedCause] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes = {
    import WorkflowExecutionCancelRequestedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes
      .builder()
      .optionallyWith(
        externalWorkflowExecution.map(value => value.buildAwsValue())
      )(_.externalWorkflowExecution)
      .optionallyWith(
        externalInitiatedEventId.map(value =>
          EventId.unwrap(value): java.lang.Long
        )
      )(_.externalInitiatedEventId)
      .optionallyWith(cause.map(value => value.unwrap))(_.cause)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionCancelRequestedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes =
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes(
        externalWorkflowExecution.map(value => value.asEditable),
        externalInitiatedEventId.map(value => value),
        cause.map(value => value)
      )
    def externalWorkflowExecution
        : Option[zio.aws.swf.model.WorkflowExecution.ReadOnly]
    def externalInitiatedEventId: Option[EventId]
    def cause: Option[zio.aws.swf.model.WorkflowExecutionCancelRequestedCause]
    def getExternalWorkflowExecution
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      AwsError.unwrapOptionField(
        "externalWorkflowExecution",
        externalWorkflowExecution
      )
    def getExternalInitiatedEventId: ZIO[Any, AwsError, EventId] = AwsError
      .unwrapOptionField("externalInitiatedEventId", externalInitiatedEventId)
    def getCause: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCancelRequestedCause
    ] = AwsError.unwrapOptionField("cause", cause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly {
    override val externalWorkflowExecution
        : Option[zio.aws.swf.model.WorkflowExecution.ReadOnly] = scala
      .Option(impl.externalWorkflowExecution())
      .map(value => zio.aws.swf.model.WorkflowExecution.wrap(value))
    override val externalInitiatedEventId: Option[EventId] = scala
      .Option(impl.externalInitiatedEventId())
      .map(value => zio.aws.swf.model.primitives.EventId(value))
    override val cause
        : Option[zio.aws.swf.model.WorkflowExecutionCancelRequestedCause] =
      scala
        .Option(impl.cause())
        .map(value =>
          zio.aws.swf.model.WorkflowExecutionCancelRequestedCause.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
