package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeActivityTypeResponse(
    typeInfo: zio.aws.swf.model.ActivityTypeInfo,
    configuration: zio.aws.swf.model.ActivityTypeConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse = {
    import DescribeActivityTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse
      .builder()
      .typeInfo(typeInfo.buildAwsValue())
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly =
    zio.aws.swf.model.DescribeActivityTypeResponse.wrap(buildAwsValue())
}
object DescribeActivityTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeActivityTypeResponse =
      zio.aws.swf.model.DescribeActivityTypeResponse(
        typeInfo.asEditable,
        configuration.asEditable
      )
    def typeInfo: zio.aws.swf.model.ActivityTypeInfo.ReadOnly
    def configuration: zio.aws.swf.model.ActivityTypeConfiguration.ReadOnly
    def getTypeInfo
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityTypeInfo.ReadOnly] =
      ZIO.succeed(typeInfo)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.ActivityTypeConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse
  ) extends zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly {
    override val typeInfo: zio.aws.swf.model.ActivityTypeInfo.ReadOnly =
      zio.aws.swf.model.ActivityTypeInfo.wrap(impl.typeInfo())
    override val configuration
        : zio.aws.swf.model.ActivityTypeConfiguration.ReadOnly =
      zio.aws.swf.model.ActivityTypeConfiguration.wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse
  ): zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly = new Wrapper(impl)
}
