package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait ScheduleLambdaFunctionFailedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause
}
object ScheduleLambdaFunctionFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause
  ): zio.aws.swf.model.ScheduleLambdaFunctionFailedCause = value match {
    case software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.ID_ALREADY_IN_USE =>
      val r = ID_ALREADY_IN_USE
      r
    case software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED =>
      val r = OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED =>
      val r = LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED
      r
    case software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION =>
      val r = LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.ScheduleLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object ID_ALREADY_IN_USE
      extends zio.aws.swf.model.ScheduleLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.ID_ALREADY_IN_USE
  }
  case object OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED
      extends zio.aws.swf.model.ScheduleLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED
  }
  case object LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED
      extends zio.aws.swf.model.ScheduleLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED
  }
  case object LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION
      extends zio.aws.swf.model.ScheduleLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedCause.LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION
  }
}
