package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Data}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionCompletedEventAttributes(
    result: Optional[Data] = Optional.Absent,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionCompletedEventAttributes = {
    import WorkflowExecutionCompletedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionCompletedEventAttributes
      .builder()
      .optionallyWith(
        result.map(value => Data.unwrap(value): java.lang.String)
      )(_.result)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionCompletedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionCompletedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes =
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes(
        result.map(value => value),
        decisionTaskCompletedEventId
      )
    def result: Optional[Data]
    def decisionTaskCompletedEventId: EventId
    def getResult: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("result", result)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionCompletedEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly {
    override val result: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionCompletedEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
