package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{Data, FailureReason}
import scala.jdk.CollectionConverters._
final case class FailWorkflowExecutionDecisionAttributes(
    reason: Optional[FailureReason] = Optional.Absent,
    details: Optional[Data] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.FailWorkflowExecutionDecisionAttributes = {
    import FailWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.FailWorkflowExecutionDecisionAttributes
      .builder()
      .optionallyWith(
        reason.map(value => FailureReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object FailWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.FailWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes(
        reason.map(value => value),
        details.map(value => value)
      )
    def reason: Optional[FailureReason]
    def details: Optional[Data]
    def getReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.FailWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly {
    override val reason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.swf.model.primitives.FailureReason(value))
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.FailWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
