package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{Data, TerminateReason}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionTerminatedEventAttributes(
    reason: Optional[TerminateReason] = Optional.Absent,
    details: Optional[Data] = Optional.Absent,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    cause: Optional[zio.aws.swf.model.WorkflowExecutionTerminatedCause] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedEventAttributes = {
    import WorkflowExecutionTerminatedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedEventAttributes
      .builder()
      .optionallyWith(
        reason.map(value => TerminateReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .childPolicy(childPolicy.unwrap)
      .optionallyWith(cause.map(value => value.unwrap))(_.cause)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionTerminatedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes =
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes(
        reason.map(value => value),
        details.map(value => value),
        childPolicy,
        cause.map(value => value)
      )
    def reason: Optional[TerminateReason]
    def details: Optional[Data]
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def cause: Optional[zio.aws.swf.model.WorkflowExecutionTerminatedCause]
    def getReason: ZIO[Any, AwsError, TerminateReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getCause: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionTerminatedCause
    ] = AwsError.unwrapOptionField("cause", cause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly {
    override val reason: Optional[TerminateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.swf.model.primitives.TerminateReason(value))
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val cause
        : Optional[zio.aws.swf.model.WorkflowExecutionTerminatedCause] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cause())
        .map(value =>
          zio.aws.swf.model.WorkflowExecutionTerminatedCause.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
