package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{Data, TaskToken}
import scala.jdk.CollectionConverters._
final case class RespondActivityTaskCompletedRequest(
    taskToken: TaskToken,
    result: Optional[Data] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest = {
    import RespondActivityTaskCompletedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        result.map(value => Data.unwrap(value): java.lang.String)
      )(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RespondActivityTaskCompletedRequest.ReadOnly =
    zio.aws.swf.model.RespondActivityTaskCompletedRequest.wrap(buildAwsValue())
}
object RespondActivityTaskCompletedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RespondActivityTaskCompletedRequest =
      zio.aws.swf.model.RespondActivityTaskCompletedRequest(
        taskToken,
        result.map(value => value)
      )
    def taskToken: TaskToken
    def result: Optional[Data]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getResult: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest
  ) extends zio.aws.swf.model.RespondActivityTaskCompletedRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val result: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest
  ): zio.aws.swf.model.RespondActivityTaskCompletedRequest.ReadOnly =
    new Wrapper(impl)
}
