package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  Tag,
  Arn,
  EventId,
  DurationInSecondsOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class StartChildWorkflowExecutionInitiatedEventAttributes(
    workflowId: WorkflowId,
    workflowType: zio.aws.swf.model.WorkflowType,
    control: Optional[Data] = Optional.Absent,
    input: Optional[Data] = Optional.Absent,
    executionStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    decisionTaskCompletedEventId: EventId,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    tagList: Optional[Iterable[Tag]] = Optional.Absent,
    lambdaRole: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes = {
    import StartChildWorkflowExecutionInitiatedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .childPolicy(childPolicy.unwrap)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
      .wrap(buildAwsValue())
}
object StartChildWorkflowExecutionInitiatedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes =
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes(
        workflowId,
        workflowType.asEditable,
        control.map(value => value),
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        taskList.asEditable,
        taskPriority.map(value => value),
        decisionTaskCompletedEventId,
        childPolicy,
        taskStartToCloseTimeout.map(value => value),
        tagList.map(value => value),
        lambdaRole.map(value => value)
      )
    def workflowId: WorkflowId
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def control: Optional[Data]
    def input: Optional[Data]
    def executionStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Optional[TaskPriority]
    def decisionTaskCompletedEventId: EventId
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def taskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def tagList: Optional[List[Tag]]
    def lambdaRole: Optional[Arn]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
  ) extends zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val control: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val tagList: Optional[List[Tag]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val lambdaRole: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
  ): zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
