package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  Data,
  WorkflowRunIdOptional,
  DomainName,
  SignalName,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class SignalWorkflowExecutionRequest(
    domain: DomainName,
    workflowId: WorkflowId,
    runId: Optional[WorkflowRunIdOptional] = Optional.Absent,
    signalName: SignalName,
    input: Optional[Data] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest = {
    import SignalWorkflowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .signalName(SignalName.unwrap(signalName): java.lang.String)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.SignalWorkflowExecutionRequest.ReadOnly =
    zio.aws.swf.model.SignalWorkflowExecutionRequest.wrap(buildAwsValue())
}
object SignalWorkflowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.SignalWorkflowExecutionRequest =
      zio.aws.swf.model.SignalWorkflowExecutionRequest(
        domain,
        workflowId,
        runId.map(value => value),
        signalName,
        input.map(value => value)
      )
    def domain: DomainName
    def workflowId: WorkflowId
    def runId: Optional[WorkflowRunIdOptional]
    def signalName: SignalName
    def input: Optional[Data]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getSignalName: ZIO[Any, Nothing, SignalName] = ZIO.succeed(signalName)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest
  ) extends zio.aws.swf.model.SignalWorkflowExecutionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Optional[WorkflowRunIdOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val signalName: SignalName =
      zio.aws.swf.model.primitives.SignalName(impl.signalName())
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest
  ): zio.aws.swf.model.SignalWorkflowExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
