package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Data}
import scala.jdk.CollectionConverters._
final case class ActivityTaskCanceledEventAttributes(
    details: Optional[Data] = Optional.Absent,
    scheduledEventId: EventId,
    startedEventId: EventId,
    latestCancelRequestedEventId: Optional[EventId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes = {
    import ActivityTaskCanceledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes
      .builder()
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .optionallyWith(
        latestCancelRequestedEventId.map(value =>
          EventId.unwrap(value): java.lang.Long
        )
      )(_.latestCancelRequestedEventId)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskCanceledEventAttributes.wrap(buildAwsValue())
}
object ActivityTaskCanceledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTaskCanceledEventAttributes =
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes(
        details.map(value => value),
        scheduledEventId,
        startedEventId,
        latestCancelRequestedEventId.map(value => value)
      )
    def details: Optional[Data]
    def scheduledEventId: EventId
    def startedEventId: EventId
    def latestCancelRequestedEventId: Optional[EventId]
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getLatestCancelRequestedEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField(
        "latestCancelRequestedEventId",
        latestCancelRequestedEventId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly {
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val latestCancelRequestedEventId: Optional[EventId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestCancelRequestedEventId())
        .map(value => zio.aws.swf.model.primitives.EventId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes
  ): zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
