package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait DecisionTaskTimeoutType {
  def unwrap: software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType
}
object DecisionTaskTimeoutType {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType
  ): zio.aws.swf.model.DecisionTaskTimeoutType = value match {
    case software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType.START_TO_CLOSE =>
      val r = START_TO_CLOSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.DecisionTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType.UNKNOWN_TO_SDK_VERSION
  }
  case object START_TO_CLOSE extends zio.aws.swf.model.DecisionTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType.START_TO_CLOSE
  }
}
