package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  WorkflowRunIdOptional,
  Tag,
  Arn,
  EventId,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionStartedEventAttributes(
    input: Optional[Data] = Optional.Absent,
    executionStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    workflowType: zio.aws.swf.model.WorkflowType,
    tagList: Optional[Iterable[Tag]] = Optional.Absent,
    continuedExecutionRunId: Optional[WorkflowRunIdOptional] = Optional.Absent,
    parentWorkflowExecution: Optional[zio.aws.swf.model.WorkflowExecution] =
      Optional.Absent,
    parentInitiatedEventId: Optional[EventId] = Optional.Absent,
    lambdaRole: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes = {
    import WorkflowExecutionStartedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
      .builder()
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .childPolicy(childPolicy.unwrap)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        continuedExecutionRunId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.continuedExecutionRunId)
      .optionallyWith(
        parentWorkflowExecution.map(value => value.buildAwsValue())
      )(_.parentWorkflowExecution)
      .optionallyWith(
        parentInitiatedEventId.map(value =>
          EventId.unwrap(value): java.lang.Long
        )
      )(_.parentInitiatedEventId)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionStartedEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionStartedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionStartedEventAttributes =
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes(
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        taskStartToCloseTimeout.map(value => value),
        childPolicy,
        taskList.asEditable,
        taskPriority.map(value => value),
        workflowType.asEditable,
        tagList.map(value => value),
        continuedExecutionRunId.map(value => value),
        parentWorkflowExecution.map(value => value.asEditable),
        parentInitiatedEventId.map(value => value),
        lambdaRole.map(value => value)
      )
    def input: Optional[Data]
    def executionStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Optional[TaskPriority]
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def tagList: Optional[List[Tag]]
    def continuedExecutionRunId: Optional[WorkflowRunIdOptional]
    def parentWorkflowExecution
        : Optional[zio.aws.swf.model.WorkflowExecution.ReadOnly]
    def parentInitiatedEventId: Optional[EventId]
    def lambdaRole: Optional[Arn]
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getContinuedExecutionRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField(
        "continuedExecutionRunId",
        continuedExecutionRunId
      )
    def getParentWorkflowExecution
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      AwsError.unwrapOptionField(
        "parentWorkflowExecution",
        parentWorkflowExecution
      )
    def getParentInitiatedEventId: ZIO[Any, AwsError, EventId] = AwsError
      .unwrapOptionField("parentInitiatedEventId", parentInitiatedEventId)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly {
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val tagList: Optional[List[Tag]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val continuedExecutionRunId: Optional[WorkflowRunIdOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continuedExecutionRunId())
        .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val parentWorkflowExecution
        : Optional[zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentWorkflowExecution())
        .map(value => zio.aws.swf.model.WorkflowExecution.wrap(value))
    override val parentInitiatedEventId: Optional[EventId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentInitiatedEventId())
        .map(value => zio.aws.swf.model.primitives.EventId(value))
    override val lambdaRole: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
