package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait StartTimerFailedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.StartTimerFailedCause
}
object StartTimerFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.StartTimerFailedCause
  ): zio.aws.swf.model.StartTimerFailedCause = value match {
    case software.amazon.awssdk.services.swf.model.StartTimerFailedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.StartTimerFailedCause.TIMER_ID_ALREADY_IN_USE =>
      val r = TIMER_ID_ALREADY_IN_USE
      r
    case software.amazon.awssdk.services.swf.model.StartTimerFailedCause.OPEN_TIMERS_LIMIT_EXCEEDED =>
      val r = OPEN_TIMERS_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.swf.model.StartTimerFailedCause.TIMER_CREATION_RATE_EXCEEDED =>
      val r = TIMER_CREATION_RATE_EXCEEDED
      r
    case software.amazon.awssdk.services.swf.model.StartTimerFailedCause.OPERATION_NOT_PERMITTED =>
      val r = OPERATION_NOT_PERMITTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.StartTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartTimerFailedCause =
      software.amazon.awssdk.services.swf.model.StartTimerFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object TIMER_ID_ALREADY_IN_USE
      extends zio.aws.swf.model.StartTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartTimerFailedCause =
      software.amazon.awssdk.services.swf.model.StartTimerFailedCause.TIMER_ID_ALREADY_IN_USE
  }
  case object OPEN_TIMERS_LIMIT_EXCEEDED
      extends zio.aws.swf.model.StartTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartTimerFailedCause =
      software.amazon.awssdk.services.swf.model.StartTimerFailedCause.OPEN_TIMERS_LIMIT_EXCEEDED
  }
  case object TIMER_CREATION_RATE_EXCEEDED
      extends zio.aws.swf.model.StartTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartTimerFailedCause =
      software.amazon.awssdk.services.swf.model.StartTimerFailedCause.TIMER_CREATION_RATE_EXCEEDED
  }
  case object OPERATION_NOT_PERMITTED
      extends zio.aws.swf.model.StartTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartTimerFailedCause =
      software.amazon.awssdk.services.swf.model.StartTimerFailedCause.OPERATION_NOT_PERMITTED
  }
}
