package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloseStatusFilter(status: zio.aws.swf.model.CloseStatus) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CloseStatusFilter = {
    import CloseStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CloseStatusFilter
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.CloseStatusFilter.ReadOnly =
    zio.aws.swf.model.CloseStatusFilter.wrap(buildAwsValue())
}
object CloseStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CloseStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CloseStatusFilter =
      zio.aws.swf.model.CloseStatusFilter(status)
    def status: zio.aws.swf.model.CloseStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.swf.model.CloseStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CloseStatusFilter
  ) extends zio.aws.swf.model.CloseStatusFilter.ReadOnly {
    override val status: zio.aws.swf.model.CloseStatus =
      zio.aws.swf.model.CloseStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CloseStatusFilter
  ): zio.aws.swf.model.CloseStatusFilter.ReadOnly = new Wrapper(impl)
}
