package zio.aws.swf
import zio.aws.swf.model.ListDomainsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.swf.model.{
  ListActivityTypesRequest,
  DeprecateActivityTypeRequest,
  UndeprecateActivityTypeRequest,
  RequestCancelWorkflowExecutionRequest,
  CountPendingDecisionTasksRequest,
  RespondDecisionTaskCompletedRequest,
  PollForDecisionTaskRequest,
  CountClosedWorkflowExecutionsRequest,
  DescribeWorkflowExecutionRequest,
  DeprecateDomainRequest,
  ListTagsForResourceRequest,
  UndeprecateDomainRequest,
  ListOpenWorkflowExecutionsRequest,
  StartWorkflowExecutionRequest,
  SignalWorkflowExecutionRequest,
  GetWorkflowExecutionHistoryRequest,
  DescribeDomainRequest,
  RegisterWorkflowTypeRequest,
  DescribeActivityTypeRequest,
  RegisterActivityTypeRequest,
  UntagResourceRequest,
  DescribeWorkflowTypeRequest,
  PollForActivityTaskRequest,
  ListClosedWorkflowExecutionsRequest,
  ListWorkflowTypesRequest,
  RecordActivityTaskHeartbeatRequest,
  TerminateWorkflowExecutionRequest,
  RegisterDomainRequest,
  RespondActivityTaskCanceledRequest,
  UndeprecateWorkflowTypeRequest,
  RespondActivityTaskFailedRequest,
  CountOpenWorkflowExecutionsRequest,
  CountPendingActivityTasksRequest,
  ListDomainsRequest,
  TagResourceRequest,
  RespondActivityTaskCompletedRequest,
  DeprecateWorkflowTypeRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.swf.SwfAsyncClient
object SwfMock extends Mock[Swf] {
  object RegisterActivityType
      extends Effect[RegisterActivityTypeRequest, AwsError, Unit]
  object DescribeActivityType
      extends Effect[
        DescribeActivityTypeRequest,
        AwsError,
        zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly
      ]
  object DescribeDomain
      extends Effect[
        DescribeDomainRequest,
        AwsError,
        zio.aws.swf.model.DescribeDomainResponse.ReadOnly
      ]
  object CountClosedWorkflowExecutions
      extends Effect[
        CountClosedWorkflowExecutionsRequest,
        AwsError,
        zio.aws.swf.model.CountClosedWorkflowExecutionsResponse.ReadOnly
      ]
  object StartWorkflowExecution
      extends Effect[
        StartWorkflowExecutionRequest,
        AwsError,
        zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly
      ]
  object UndeprecateDomain
      extends Effect[UndeprecateDomainRequest, AwsError, Unit]
  object CountPendingDecisionTasks
      extends Effect[
        CountPendingDecisionTasksRequest,
        AwsError,
        zio.aws.swf.model.CountPendingDecisionTasksResponse.ReadOnly
      ]
  object SignalWorkflowExecution
      extends Effect[SignalWorkflowExecutionRequest, AwsError, Unit]
  object UndeprecateActivityType
      extends Effect[UndeprecateActivityTypeRequest, AwsError, Unit]
  object PollForActivityTask
      extends Effect[
        PollForActivityTaskRequest,
        AwsError,
        zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly
      ]
  object ListDomains
      extends Stream[
        ListDomainsRequest,
        AwsError,
        zio.aws.swf.model.DomainInfo.ReadOnly
      ]
  object ListDomainsPaginated
      extends Effect[ListDomainsRequest, AwsError, ReadOnly]
  object ListOpenWorkflowExecutions
      extends Stream[
        ListOpenWorkflowExecutionsRequest,
        AwsError,
        zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
      ]
  object ListOpenWorkflowExecutionsPaginated
      extends Effect[
        ListOpenWorkflowExecutionsRequest,
        AwsError,
        zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly
      ]
  object ListClosedWorkflowExecutions
      extends Stream[
        ListClosedWorkflowExecutionsRequest,
        AwsError,
        zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
      ]
  object ListClosedWorkflowExecutionsPaginated
      extends Effect[
        ListClosedWorkflowExecutionsRequest,
        AwsError,
        zio.aws.swf.model.ListClosedWorkflowExecutionsResponse.ReadOnly
      ]
  object RegisterDomain extends Effect[RegisterDomainRequest, AwsError, Unit]
  object GetWorkflowExecutionHistory
      extends Stream[
        GetWorkflowExecutionHistoryRequest,
        AwsError,
        zio.aws.swf.model.HistoryEvent.ReadOnly
      ]
  object GetWorkflowExecutionHistoryPaginated
      extends Effect[
        GetWorkflowExecutionHistoryRequest,
        AwsError,
        zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly
      ]
  object RespondActivityTaskFailed
      extends Effect[RespondActivityTaskFailedRequest, AwsError, Unit]
  object RegisterWorkflowType
      extends Effect[RegisterWorkflowTypeRequest, AwsError, Unit]
  object ListActivityTypes
      extends Stream[
        ListActivityTypesRequest,
        AwsError,
        zio.aws.swf.model.ActivityTypeInfo.ReadOnly
      ]
  object ListActivityTypesPaginated
      extends Effect[
        ListActivityTypesRequest,
        AwsError,
        zio.aws.swf.model.ListActivityTypesResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object RespondActivityTaskCompleted
      extends Effect[RespondActivityTaskCompletedRequest, AwsError, Unit]
  object CountOpenWorkflowExecutions
      extends Effect[
        CountOpenWorkflowExecutionsRequest,
        AwsError,
        zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly
      ]
  object TerminateWorkflowExecution
      extends Effect[TerminateWorkflowExecutionRequest, AwsError, Unit]
  object CountPendingActivityTasks
      extends Effect[
        CountPendingActivityTasksRequest,
        AwsError,
        zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly
      ]
  object RespondDecisionTaskCompleted
      extends Effect[RespondDecisionTaskCompletedRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DeprecateWorkflowType
      extends Effect[DeprecateWorkflowTypeRequest, AwsError, Unit]
  object PollForDecisionTask
      extends Stream[
        PollForDecisionTaskRequest,
        AwsError,
        zio.aws.swf.model.HistoryEvent.ReadOnly
      ]
  object PollForDecisionTaskPaginated
      extends Effect[
        PollForDecisionTaskRequest,
        AwsError,
        zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly
      ]
  object DeprecateDomain extends Effect[DeprecateDomainRequest, AwsError, Unit]
  object RespondActivityTaskCanceled
      extends Effect[RespondActivityTaskCanceledRequest, AwsError, Unit]
  object RequestCancelWorkflowExecution
      extends Effect[RequestCancelWorkflowExecutionRequest, AwsError, Unit]
  object DescribeWorkflowType
      extends Effect[
        DescribeWorkflowTypeRequest,
        AwsError,
        zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly
      ]
  object UndeprecateWorkflowType
      extends Effect[UndeprecateWorkflowTypeRequest, AwsError, Unit]
  object RecordActivityTaskHeartbeat
      extends Effect[
        RecordActivityTaskHeartbeatRequest,
        AwsError,
        zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly
      ]
  object ListWorkflowTypes
      extends Stream[
        ListWorkflowTypesRequest,
        AwsError,
        zio.aws.swf.model.WorkflowTypeInfo.ReadOnly
      ]
  object ListWorkflowTypesPaginated
      extends Effect[
        ListWorkflowTypesRequest,
        AwsError,
        zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly
      ]
  object DescribeWorkflowExecution
      extends Effect[
        DescribeWorkflowExecutionRequest,
        AwsError,
        zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly
      ]
  object DeprecateActivityType
      extends Effect[DeprecateActivityTypeRequest, AwsError, Unit]
  val compose: URLayer[Proxy, Swf] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Swf] { rts =>
        zio.ZIO.succeed {
          new Swf {
            val api: SwfAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Swf = this
            def registerActivityType(
                request: RegisterActivityTypeRequest
            ): IO[AwsError, Unit] = proxy(RegisterActivityType, request)
            def describeActivityType(request: DescribeActivityTypeRequest): IO[
              AwsError,
              zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly
            ] = proxy(DescribeActivityType, request)
            def describeDomain(
                request: DescribeDomainRequest
            ): IO[AwsError, zio.aws.swf.model.DescribeDomainResponse.ReadOnly] =
              proxy(DescribeDomain, request)
            def countClosedWorkflowExecutions(
                request: CountClosedWorkflowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.CountClosedWorkflowExecutionsResponse.ReadOnly
            ] = proxy(CountClosedWorkflowExecutions, request)
            def startWorkflowExecution(
                request: StartWorkflowExecutionRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly
            ] = proxy(StartWorkflowExecution, request)
            def undeprecateDomain(
                request: UndeprecateDomainRequest
            ): IO[AwsError, Unit] = proxy(UndeprecateDomain, request)
            def countPendingDecisionTasks(
                request: CountPendingDecisionTasksRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.CountPendingDecisionTasksResponse.ReadOnly
            ] = proxy(CountPendingDecisionTasks, request)
            def signalWorkflowExecution(
                request: SignalWorkflowExecutionRequest
            ): IO[AwsError, Unit] = proxy(SignalWorkflowExecution, request)
            def undeprecateActivityType(
                request: UndeprecateActivityTypeRequest
            ): IO[AwsError, Unit] = proxy(UndeprecateActivityType, request)
            def pollForActivityTask(request: PollForActivityTaskRequest): IO[
              AwsError,
              zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly
            ] = proxy(PollForActivityTask, request)
            def listDomains(
                request: ListDomainsRequest
            ): ZStream[Any, AwsError, zio.aws.swf.model.DomainInfo.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDomains, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDomainsPaginated(
                request: ListDomainsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListDomainsPaginated, request)
            def listOpenWorkflowExecutions(
                request: ListOpenWorkflowExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOpenWorkflowExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOpenWorkflowExecutionsPaginated(
                request: ListOpenWorkflowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly
            ] = proxy(ListOpenWorkflowExecutionsPaginated, request)
            def listClosedWorkflowExecutions(
                request: ListClosedWorkflowExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListClosedWorkflowExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listClosedWorkflowExecutionsPaginated(
                request: ListClosedWorkflowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.ListClosedWorkflowExecutionsResponse.ReadOnly
            ] = proxy(ListClosedWorkflowExecutionsPaginated, request)
            def registerDomain(
                request: RegisterDomainRequest
            ): IO[AwsError, Unit] = proxy(RegisterDomain, request)
            def getWorkflowExecutionHistory(
                request: GetWorkflowExecutionHistoryRequest
            ): ZStream[Any, AwsError, zio.aws.swf.model.HistoryEvent.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetWorkflowExecutionHistory, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getWorkflowExecutionHistoryPaginated(
                request: GetWorkflowExecutionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly
            ] = proxy(GetWorkflowExecutionHistoryPaginated, request)
            def respondActivityTaskFailed(
                request: RespondActivityTaskFailedRequest
            ): IO[AwsError, Unit] = proxy(RespondActivityTaskFailed, request)
            def registerWorkflowType(
                request: RegisterWorkflowTypeRequest
            ): IO[AwsError, Unit] = proxy(RegisterWorkflowType, request)
            def listActivityTypes(request: ListActivityTypesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.swf.model.ActivityTypeInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListActivityTypes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listActivityTypesPaginated(
                request: ListActivityTypesRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.ListActivityTypesResponse.ReadOnly
            ] = proxy(ListActivityTypesPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def respondActivityTaskCompleted(
                request: RespondActivityTaskCompletedRequest
            ): IO[AwsError, Unit] = proxy(RespondActivityTaskCompleted, request)
            def countOpenWorkflowExecutions(
                request: CountOpenWorkflowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly
            ] = proxy(CountOpenWorkflowExecutions, request)
            def terminateWorkflowExecution(
                request: TerminateWorkflowExecutionRequest
            ): IO[AwsError, Unit] = proxy(TerminateWorkflowExecution, request)
            def countPendingActivityTasks(
                request: CountPendingActivityTasksRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly
            ] = proxy(CountPendingActivityTasks, request)
            def respondDecisionTaskCompleted(
                request: RespondDecisionTaskCompletedRequest
            ): IO[AwsError, Unit] = proxy(RespondDecisionTaskCompleted, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def deprecateWorkflowType(
                request: DeprecateWorkflowTypeRequest
            ): IO[AwsError, Unit] = proxy(DeprecateWorkflowType, request)
            def pollForDecisionTask(
                request: PollForDecisionTaskRequest
            ): ZStream[Any, AwsError, zio.aws.swf.model.HistoryEvent.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(PollForDecisionTask, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def pollForDecisionTaskPaginated(
                request: PollForDecisionTaskRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly
            ] = proxy(PollForDecisionTaskPaginated, request)
            def deprecateDomain(
                request: DeprecateDomainRequest
            ): IO[AwsError, Unit] = proxy(DeprecateDomain, request)
            def respondActivityTaskCanceled(
                request: RespondActivityTaskCanceledRequest
            ): IO[AwsError, Unit] = proxy(RespondActivityTaskCanceled, request)
            def requestCancelWorkflowExecution(
                request: RequestCancelWorkflowExecutionRequest
            ): IO[AwsError, Unit] =
              proxy(RequestCancelWorkflowExecution, request)
            def describeWorkflowType(request: DescribeWorkflowTypeRequest): IO[
              AwsError,
              zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly
            ] = proxy(DescribeWorkflowType, request)
            def undeprecateWorkflowType(
                request: UndeprecateWorkflowTypeRequest
            ): IO[AwsError, Unit] = proxy(UndeprecateWorkflowType, request)
            def recordActivityTaskHeartbeat(
                request: RecordActivityTaskHeartbeatRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly
            ] = proxy(RecordActivityTaskHeartbeat, request)
            def listWorkflowTypes(request: ListWorkflowTypesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.swf.model.WorkflowTypeInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflowTypes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowTypesPaginated(
                request: ListWorkflowTypesRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly
            ] = proxy(ListWorkflowTypesPaginated, request)
            def describeWorkflowExecution(
                request: DescribeWorkflowExecutionRequest
            ): IO[
              AwsError,
              zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly
            ] = proxy(DescribeWorkflowExecution, request)
            def deprecateActivityType(
                request: DeprecateActivityTypeRequest
            ): IO[AwsError, Unit] = proxy(DeprecateActivityType, request)
          }
        }
      }
    }
  }
}
