package zio.aws.swf.model
import zio.aws.swf.model.primitives.{
  ReverseOrder,
  PageSize,
  PageToken,
  DomainName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListOpenWorkflowExecutionsRequest(
    domain: DomainName,
    startTimeFilter: zio.aws.swf.model.ExecutionTimeFilter,
    typeFilter: Optional[zio.aws.swf.model.WorkflowTypeFilter] =
      Optional.Absent,
    tagFilter: Optional[zio.aws.swf.model.TagFilter] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent,
    maximumPageSize: Optional[PageSize] = Optional.Absent,
    reverseOrder: Optional[ReverseOrder] = Optional.Absent,
    executionFilter: Optional[zio.aws.swf.model.WorkflowExecutionFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest = {
    import ListOpenWorkflowExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .startTimeFilter(startTimeFilter.buildAwsValue())
      .optionallyWith(typeFilter.map(value => value.buildAwsValue()))(
        _.typeFilter
      )
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .optionallyWith(executionFilter.map(value => value.buildAwsValue()))(
        _.executionFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListOpenWorkflowExecutionsRequest.ReadOnly =
    zio.aws.swf.model.ListOpenWorkflowExecutionsRequest.wrap(buildAwsValue())
}
object ListOpenWorkflowExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListOpenWorkflowExecutionsRequest =
      zio.aws.swf.model.ListOpenWorkflowExecutionsRequest(
        domain,
        startTimeFilter.asEditable,
        typeFilter.map(value => value.asEditable),
        tagFilter.map(value => value.asEditable),
        nextPageToken.map(value => value),
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value),
        executionFilter.map(value => value.asEditable)
      )
    def domain: DomainName
    def startTimeFilter: zio.aws.swf.model.ExecutionTimeFilter.ReadOnly
    def typeFilter: Optional[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly]
    def tagFilter: Optional[zio.aws.swf.model.TagFilter.ReadOnly]
    def nextPageToken: Optional[PageToken]
    def maximumPageSize: Optional[PageSize]
    def reverseOrder: Optional[ReverseOrder]
    def executionFilter
        : Optional[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getStartTimeFilter
        : ZIO[Any, Nothing, zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      ZIO.succeed(startTimeFilter)
    def getTypeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      AwsError.unwrapOptionField("typeFilter", typeFilter)
    def getTagFilter: ZIO[Any, AwsError, zio.aws.swf.model.TagFilter.ReadOnly] =
      AwsError.unwrapOptionField("tagFilter", tagFilter)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
    def getExecutionFilter: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("executionFilter", executionFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest
  ) extends zio.aws.swf.model.ListOpenWorkflowExecutionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val startTimeFilter
        : zio.aws.swf.model.ExecutionTimeFilter.ReadOnly =
      zio.aws.swf.model.ExecutionTimeFilter.wrap(impl.startTimeFilter())
    override val typeFilter
        : Optional[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeFilter())
        .map(value => zio.aws.swf.model.WorkflowTypeFilter.wrap(value))
    override val tagFilter: Optional[zio.aws.swf.model.TagFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilter())
        .map(value => zio.aws.swf.model.TagFilter.wrap(value))
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val maximumPageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Optional[ReverseOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
    override val executionFilter
        : Optional[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionFilter())
        .map(value => zio.aws.swf.model.WorkflowExecutionFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest
  ): zio.aws.swf.model.ListOpenWorkflowExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
