package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{Data, MarkerName}
import scala.jdk.CollectionConverters._
final case class RecordMarkerDecisionAttributes(
    markerName: MarkerName,
    details: Optional[Data] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RecordMarkerDecisionAttributes = {
    import RecordMarkerDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RecordMarkerDecisionAttributes
      .builder()
      .markerName(MarkerName.unwrap(markerName): java.lang.String)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly =
    zio.aws.swf.model.RecordMarkerDecisionAttributes.wrap(buildAwsValue())
}
object RecordMarkerDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RecordMarkerDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RecordMarkerDecisionAttributes =
      zio.aws.swf.model
        .RecordMarkerDecisionAttributes(markerName, details.map(value => value))
    def markerName: MarkerName
    def details: Optional[Data]
    def getMarkerName: ZIO[Any, Nothing, MarkerName] = ZIO.succeed(markerName)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RecordMarkerDecisionAttributes
  ) extends zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly {
    override val markerName: MarkerName =
      zio.aws.swf.model.primitives.MarkerName(impl.markerName())
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RecordMarkerDecisionAttributes
  ): zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly = new Wrapper(
    impl
  )
}
