package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DurationInDays
import scala.jdk.CollectionConverters._
final case class DomainConfiguration(
    workflowExecutionRetentionPeriodInDays: DurationInDays
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DomainConfiguration = {
    import DomainConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DomainConfiguration
      .builder()
      .workflowExecutionRetentionPeriodInDays(
        DurationInDays.unwrap(
          workflowExecutionRetentionPeriodInDays
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DomainConfiguration.ReadOnly =
    zio.aws.swf.model.DomainConfiguration.wrap(buildAwsValue())
}
object DomainConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DomainConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DomainConfiguration = zio.aws.swf.model
      .DomainConfiguration(workflowExecutionRetentionPeriodInDays)
    def workflowExecutionRetentionPeriodInDays: DurationInDays
    def getWorkflowExecutionRetentionPeriodInDays
        : ZIO[Any, Nothing, DurationInDays] =
      ZIO.succeed(workflowExecutionRetentionPeriodInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DomainConfiguration
  ) extends zio.aws.swf.model.DomainConfiguration.ReadOnly {
    override val workflowExecutionRetentionPeriodInDays: DurationInDays =
      zio.aws.swf.model.primitives
        .DurationInDays(impl.workflowExecutionRetentionPeriodInDays())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DomainConfiguration
  ): zio.aws.swf.model.DomainConfiguration.ReadOnly = new Wrapper(impl)
}
