package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class UndeprecateActivityTypeRequest(
    domain: DomainName,
    activityType: zio.aws.swf.model.ActivityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest = {
    import UndeprecateActivityTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .activityType(activityType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.UndeprecateActivityTypeRequest.ReadOnly =
    zio.aws.swf.model.UndeprecateActivityTypeRequest.wrap(buildAwsValue())
}
object UndeprecateActivityTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.UndeprecateActivityTypeRequest =
      zio.aws.swf.model
        .UndeprecateActivityTypeRequest(domain, activityType.asEditable)
    def domain: DomainName
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest
  ) extends zio.aws.swf.model.UndeprecateActivityTypeRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest
  ): zio.aws.swf.model.UndeprecateActivityTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
