package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  Tag,
  WorkflowRunId,
  Arn,
  EventId,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionContinuedAsNewEventAttributes(
    input: Optional[Data] = Optional.Absent,
    decisionTaskCompletedEventId: EventId,
    newExecutionRunId: WorkflowRunId,
    executionStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    tagList: Optional[Iterable[Tag]] = Optional.Absent,
    workflowType: zio.aws.swf.model.WorkflowType,
    lambdaRole: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes = {
    import WorkflowExecutionContinuedAsNewEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
      .builder()
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .newExecutionRunId(
        WorkflowRunId.unwrap(newExecutionRunId): java.lang.String
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .childPolicy(childPolicy.unwrap)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionContinuedAsNewEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes =
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes(
        input.map(value => value),
        decisionTaskCompletedEventId,
        newExecutionRunId,
        executionStartToCloseTimeout.map(value => value),
        taskList.asEditable,
        taskPriority.map(value => value),
        taskStartToCloseTimeout.map(value => value),
        childPolicy,
        tagList.map(value => value),
        workflowType.asEditable,
        lambdaRole.map(value => value)
      )
    def input: Optional[Data]
    def decisionTaskCompletedEventId: EventId
    def newExecutionRunId: WorkflowRunId
    def executionStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Optional[TaskPriority]
    def taskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def tagList: Optional[List[Tag]]
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def lambdaRole: Optional[Arn]
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getNewExecutionRunId: ZIO[Any, Nothing, WorkflowRunId] =
      ZIO.succeed(newExecutionRunId)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly {
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val newExecutionRunId: WorkflowRunId =
      zio.aws.swf.model.primitives.WorkflowRunId(impl.newExecutionRunId())
    override val executionStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val tagList: Optional[List[Tag]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val lambdaRole: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly =
    new Wrapper(impl)
}
