package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class CompleteWorkflowExecutionFailedEventAttributes(
    cause: zio.aws.swf.model.CompleteWorkflowExecutionFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes = {
    import CompleteWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes
      .builder()
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object CompleteWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes(
        cause,
        decisionTaskCompletedEventId
      )
    def cause: zio.aws.swf.model.CompleteWorkflowExecutionFailedCause
    def decisionTaskCompletedEventId: EventId
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.CompleteWorkflowExecutionFailedCause
    ] = ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val cause: zio.aws.swf.model.CompleteWorkflowExecutionFailedCause =
      zio.aws.swf.model.CompleteWorkflowExecutionFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
