package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{Data, EventId, WorkflowId}
import scala.jdk.CollectionConverters._
final case class StartChildWorkflowExecutionFailedEventAttributes(
    workflowType: zio.aws.swf.model.WorkflowType,
    cause: zio.aws.swf.model.StartChildWorkflowExecutionFailedCause,
    workflowId: WorkflowId,
    initiatedEventId: EventId,
    decisionTaskCompletedEventId: EventId,
    control: Optional[Data] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes = {
    import StartChildWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes
      .builder()
      .workflowType(workflowType.buildAwsValue())
      .cause(cause.unwrap)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object StartChildWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes(
        workflowType.asEditable,
        cause,
        workflowId,
        initiatedEventId,
        decisionTaskCompletedEventId,
        control.map(value => value)
      )
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def cause: zio.aws.swf.model.StartChildWorkflowExecutionFailedCause
    def workflowId: WorkflowId
    def initiatedEventId: EventId
    def decisionTaskCompletedEventId: EventId
    def control: Optional[Data]
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.StartChildWorkflowExecutionFailedCause
    ] = ZIO.succeed(cause)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val cause
        : zio.aws.swf.model.StartChildWorkflowExecutionFailedCause =
      zio.aws.swf.model.StartChildWorkflowExecutionFailedCause
        .wrap(impl.cause())
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val control: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
