package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.Canceled
import scala.jdk.CollectionConverters._
final case class RecordActivityTaskHeartbeatResponse(
    cancelRequested: Canceled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse = {
    import RecordActivityTaskHeartbeatResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse
      .builder()
      .cancelRequested(Canceled.unwrap(cancelRequested): java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly =
    zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.wrap(buildAwsValue())
}
object RecordActivityTaskHeartbeatResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RecordActivityTaskHeartbeatResponse =
      zio.aws.swf.model.RecordActivityTaskHeartbeatResponse(cancelRequested)
    def cancelRequested: Canceled
    def getCancelRequested: ZIO[Any, Nothing, Canceled] =
      ZIO.succeed(cancelRequested)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse
  ) extends zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly {
    override val cancelRequested: Canceled =
      zio.aws.swf.model.primitives.Canceled(impl.cancelRequested())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse
  ): zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly =
    new Wrapper(impl)
}
