package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class LambdaFunctionStartedEventAttributes(
    scheduledEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.LambdaFunctionStartedEventAttributes = {
    import LambdaFunctionStartedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.LambdaFunctionStartedEventAttributes
      .builder()
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly =
    zio.aws.swf.model.LambdaFunctionStartedEventAttributes.wrap(buildAwsValue())
}
object LambdaFunctionStartedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.LambdaFunctionStartedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.LambdaFunctionStartedEventAttributes =
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes(scheduledEventId)
    def scheduledEventId: EventId
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionStartedEventAttributes
  ) extends zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly {
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionStartedEventAttributes
  ): zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
