package zio.aws.swf.model
import zio.aws.swf.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExecutionTimeFilter(
    oldestDate: Timestamp,
    latestDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ExecutionTimeFilter = {
    import ExecutionTimeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ExecutionTimeFilter
      .builder()
      .oldestDate(Timestamp.unwrap(oldestDate): Instant)
      .optionallyWith(
        latestDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestDate)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ExecutionTimeFilter.ReadOnly =
    zio.aws.swf.model.ExecutionTimeFilter.wrap(buildAwsValue())
}
object ExecutionTimeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ExecutionTimeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ExecutionTimeFilter = zio.aws.swf.model
      .ExecutionTimeFilter(oldestDate, latestDate.map(value => value))
    def oldestDate: Timestamp
    def latestDate: Optional[Timestamp]
    def getOldestDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(oldestDate)
    def getLatestDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestDate", latestDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ExecutionTimeFilter
  ) extends zio.aws.swf.model.ExecutionTimeFilter.ReadOnly {
    override val oldestDate: Timestamp =
      zio.aws.swf.model.primitives.Timestamp(impl.oldestDate())
    override val latestDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestDate())
      .map(value => zio.aws.swf.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ExecutionTimeFilter
  ): zio.aws.swf.model.ExecutionTimeFilter.ReadOnly = new Wrapper(impl)
}
