package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Decision(
    decisionType: zio.aws.swf.model.DecisionType,
    scheduleActivityTaskDecisionAttributes: Optional[
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes
    ] = Optional.Absent,
    requestCancelActivityTaskDecisionAttributes: Optional[
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes
    ] = Optional.Absent,
    completeWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    failWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    cancelWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    continueAsNewWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    recordMarkerDecisionAttributes: Optional[
      zio.aws.swf.model.RecordMarkerDecisionAttributes
    ] = Optional.Absent,
    startTimerDecisionAttributes: Optional[
      zio.aws.swf.model.StartTimerDecisionAttributes
    ] = Optional.Absent,
    cancelTimerDecisionAttributes: Optional[
      zio.aws.swf.model.CancelTimerDecisionAttributes
    ] = Optional.Absent,
    signalExternalWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    requestCancelExternalWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    startChildWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes
    ] = Optional.Absent,
    scheduleLambdaFunctionDecisionAttributes: Optional[
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.swf.model.Decision = {
    import Decision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.Decision
      .builder()
      .decisionType(decisionType.unwrap)
      .optionallyWith(
        scheduleActivityTaskDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleActivityTaskDecisionAttributes)
      .optionallyWith(
        requestCancelActivityTaskDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelActivityTaskDecisionAttributes)
      .optionallyWith(
        completeWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.completeWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        failWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.failWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        cancelWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.cancelWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        continueAsNewWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.continueAsNewWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        recordMarkerDecisionAttributes.map(value => value.buildAwsValue())
      )(_.recordMarkerDecisionAttributes)
      .optionallyWith(
        startTimerDecisionAttributes.map(value => value.buildAwsValue())
      )(_.startTimerDecisionAttributes)
      .optionallyWith(
        cancelTimerDecisionAttributes.map(value => value.buildAwsValue())
      )(_.cancelTimerDecisionAttributes)
      .optionallyWith(
        signalExternalWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.signalExternalWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        requestCancelExternalWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelExternalWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        startChildWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startChildWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        scheduleLambdaFunctionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleLambdaFunctionDecisionAttributes)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.Decision.ReadOnly =
    zio.aws.swf.model.Decision.wrap(buildAwsValue())
}
object Decision {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.Decision] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.Decision = zio.aws.swf.model.Decision(
      decisionType,
      scheduleActivityTaskDecisionAttributes.map(value => value.asEditable),
      requestCancelActivityTaskDecisionAttributes.map(value =>
        value.asEditable
      ),
      completeWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      failWorkflowExecutionDecisionAttributes.map(value => value.asEditable),
      cancelWorkflowExecutionDecisionAttributes.map(value => value.asEditable),
      continueAsNewWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      recordMarkerDecisionAttributes.map(value => value.asEditable),
      startTimerDecisionAttributes.map(value => value.asEditable),
      cancelTimerDecisionAttributes.map(value => value.asEditable),
      signalExternalWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      requestCancelExternalWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      startChildWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      scheduleLambdaFunctionDecisionAttributes.map(value => value.asEditable)
    )
    def decisionType: zio.aws.swf.model.DecisionType
    def scheduleActivityTaskDecisionAttributes: Optional[
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly
    ]
    def requestCancelActivityTaskDecisionAttributes: Optional[
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly
    ]
    def completeWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def failWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def cancelWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def continueAsNewWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def recordMarkerDecisionAttributes
        : Optional[zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly]
    def startTimerDecisionAttributes
        : Optional[zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly]
    def cancelTimerDecisionAttributes
        : Optional[zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly]
    def signalExternalWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def requestCancelExternalWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def startChildWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def scheduleLambdaFunctionDecisionAttributes: Optional[
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly
    ]
    def getDecisionType: ZIO[Any, Nothing, zio.aws.swf.model.DecisionType] =
      ZIO.succeed(decisionType)
    def getScheduleActivityTaskDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleActivityTaskDecisionAttributes",
      scheduleActivityTaskDecisionAttributes
    )
    def getRequestCancelActivityTaskDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelActivityTaskDecisionAttributes",
      requestCancelActivityTaskDecisionAttributes
    )
    def getCompleteWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "completeWorkflowExecutionDecisionAttributes",
      completeWorkflowExecutionDecisionAttributes
    )
    def getFailWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "failWorkflowExecutionDecisionAttributes",
      failWorkflowExecutionDecisionAttributes
    )
    def getCancelWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelWorkflowExecutionDecisionAttributes",
      cancelWorkflowExecutionDecisionAttributes
    )
    def getContinueAsNewWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continueAsNewWorkflowExecutionDecisionAttributes",
      continueAsNewWorkflowExecutionDecisionAttributes
    )
    def getRecordMarkerDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordMarkerDecisionAttributes",
      recordMarkerDecisionAttributes
    )
    def getStartTimerDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startTimerDecisionAttributes",
      startTimerDecisionAttributes
    )
    def getCancelTimerDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelTimerDecisionAttributes",
      cancelTimerDecisionAttributes
    )
    def getSignalExternalWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signalExternalWorkflowExecutionDecisionAttributes",
      signalExternalWorkflowExecutionDecisionAttributes
    )
    def getRequestCancelExternalWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelExternalWorkflowExecutionDecisionAttributes",
      requestCancelExternalWorkflowExecutionDecisionAttributes
    )
    def getStartChildWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startChildWorkflowExecutionDecisionAttributes",
      startChildWorkflowExecutionDecisionAttributes
    )
    def getScheduleLambdaFunctionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleLambdaFunctionDecisionAttributes",
      scheduleLambdaFunctionDecisionAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.Decision
  ) extends zio.aws.swf.model.Decision.ReadOnly {
    override val decisionType: zio.aws.swf.model.DecisionType =
      zio.aws.swf.model.DecisionType.wrap(impl.decisionType())
    override val scheduleActivityTaskDecisionAttributes: Optional[
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleActivityTaskDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.wrap(value)
      )
    override val requestCancelActivityTaskDecisionAttributes: Optional[
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requestCancelActivityTaskDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes
          .wrap(value)
      )
    override val completeWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completeWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val failWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.wrap(value)
      )
    override val cancelWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.wrap(value)
      )
    override val continueAsNewWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.continueAsNewWorkflowExecutionDecisionAttributes()
      )
      .map(value =>
        zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val recordMarkerDecisionAttributes
        : Optional[zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordMarkerDecisionAttributes())
        .map(value =>
          zio.aws.swf.model.RecordMarkerDecisionAttributes.wrap(value)
        )
    override val startTimerDecisionAttributes
        : Optional[zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimerDecisionAttributes())
        .map(value =>
          zio.aws.swf.model.StartTimerDecisionAttributes.wrap(value)
        )
    override val cancelTimerDecisionAttributes
        : Optional[zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cancelTimerDecisionAttributes())
        .map(value =>
          zio.aws.swf.model.CancelTimerDecisionAttributes.wrap(value)
        )
    override val signalExternalWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.signalExternalWorkflowExecutionDecisionAttributes()
      )
      .map(value =>
        zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val requestCancelExternalWorkflowExecutionDecisionAttributes
        : Optional[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.requestCancelExternalWorkflowExecutionDecisionAttributes()
      )
      .map(value =>
        zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val startChildWorkflowExecutionDecisionAttributes: Optional[
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.startChildWorkflowExecutionDecisionAttributes()
      )
      .map(value =>
        zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val scheduleLambdaFunctionDecisionAttributes: Optional[
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleLambdaFunctionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.Decision
  ): zio.aws.swf.model.Decision.ReadOnly = new Wrapper(impl)
}
