package zio.aws.swf
import zio.aws.core.config.AwsConfig
import zio.aws.swf.model.ListDomainsResponse.ReadOnly
import zio.aws.swf.model.{
  ListActivityTypesRequest,
  DeprecateActivityTypeRequest,
  UndeprecateActivityTypeRequest,
  RequestCancelWorkflowExecutionRequest,
  CountPendingDecisionTasksRequest,
  RespondDecisionTaskCompletedRequest,
  PollForDecisionTaskRequest,
  CountClosedWorkflowExecutionsRequest,
  DescribeWorkflowExecutionRequest,
  DeprecateDomainRequest,
  ListTagsForResourceRequest,
  UndeprecateDomainRequest,
  ListOpenWorkflowExecutionsRequest,
  StartWorkflowExecutionRequest,
  SignalWorkflowExecutionRequest,
  GetWorkflowExecutionHistoryRequest,
  DescribeDomainRequest,
  RegisterWorkflowTypeRequest,
  DescribeActivityTypeRequest,
  RegisterActivityTypeRequest,
  UntagResourceRequest,
  DescribeWorkflowTypeRequest,
  PollForActivityTaskRequest,
  ListClosedWorkflowExecutionsRequest,
  ListWorkflowTypesRequest,
  RecordActivityTaskHeartbeatRequest,
  TerminateWorkflowExecutionRequest,
  RegisterDomainRequest,
  RespondActivityTaskCanceledRequest,
  UndeprecateWorkflowTypeRequest,
  RespondActivityTaskFailedRequest,
  CountOpenWorkflowExecutionsRequest,
  CountPendingActivityTasksRequest,
  ListDomainsRequest,
  TagResourceRequest,
  RespondActivityTaskCompletedRequest,
  DeprecateWorkflowTypeRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.swf.model.{
  DeprecateWorkflowTypeResponse,
  DescribeWorkflowTypeResponse,
  RespondActivityTaskCompletedResponse,
  ListDomainsResponse,
  DescribeDomainResponse,
  CountOpenWorkflowExecutionsResponse,
  RegisterWorkflowTypeResponse,
  PollForActivityTaskResponse,
  ListClosedWorkflowExecutionsResponse,
  DeprecateActivityTypeResponse,
  UndeprecateDomainResponse,
  DescribeWorkflowExecutionResponse,
  RequestCancelWorkflowExecutionResponse,
  TerminateWorkflowExecutionResponse,
  StartWorkflowExecutionResponse,
  RegisterDomainResponse,
  ListTagsForResourceResponse,
  GetWorkflowExecutionHistoryResponse,
  UntagResourceResponse,
  RespondActivityTaskFailedResponse,
  DomainInfo,
  DeprecateDomainResponse,
  UndeprecateActivityTypeResponse,
  RecordActivityTaskHeartbeatResponse,
  WorkflowExecutionInfo,
  ListActivityTypesResponse,
  RegisterActivityTypeResponse,
  CountPendingActivityTasksResponse,
  PollForDecisionTaskResponse,
  CountPendingDecisionTasksResponse,
  UndeprecateWorkflowTypeResponse,
  ListOpenWorkflowExecutionsResponse,
  RespondActivityTaskCanceledResponse,
  CountClosedWorkflowExecutionsResponse,
  DescribeActivityTypeResponse,
  TagResourceResponse,
  SignalWorkflowExecutionResponse,
  HistoryEvent,
  RespondDecisionTaskCompletedResponse,
  ActivityTypeInfo,
  ListWorkflowTypesResponse,
  WorkflowTypeInfo
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.swf.{
  SwfAsyncClientBuilder,
  SwfAsyncClient
}
import software.amazon.awssdk.services.swf.paginators.{
  ListClosedWorkflowExecutionsPublisher,
  ListWorkflowTypesPublisher,
  ListActivityTypesPublisher,
  ListDomainsPublisher,
  GetWorkflowExecutionHistoryPublisher,
  ListOpenWorkflowExecutionsPublisher,
  PollForDecisionTaskPublisher
}
import scala.jdk.CollectionConverters._
trait Swf extends AspectSupport[Swf] {
  val api: SwfAsyncClient
  def registerActivityType(
      request: RegisterActivityTypeRequest
  ): IO[AwsError, Unit]
  def describeActivityType(
      request: DescribeActivityTypeRequest
  ): IO[AwsError, zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly]
  def describeDomain(
      request: DescribeDomainRequest
  ): IO[AwsError, zio.aws.swf.model.DescribeDomainResponse.ReadOnly]
  def countClosedWorkflowExecutions(
      request: CountClosedWorkflowExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.swf.model.CountClosedWorkflowExecutionsResponse.ReadOnly
  ]
  def startWorkflowExecution(
      request: StartWorkflowExecutionRequest
  ): IO[AwsError, zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly]
  def undeprecateDomain(request: UndeprecateDomainRequest): IO[AwsError, Unit]
  def countPendingDecisionTasks(
      request: CountPendingDecisionTasksRequest
  ): IO[AwsError, zio.aws.swf.model.CountPendingDecisionTasksResponse.ReadOnly]
  def signalWorkflowExecution(
      request: SignalWorkflowExecutionRequest
  ): IO[AwsError, Unit]
  def undeprecateActivityType(
      request: UndeprecateActivityTypeRequest
  ): IO[AwsError, Unit]
  def pollForActivityTask(
      request: PollForActivityTaskRequest
  ): IO[AwsError, zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly]
  def listDomains(
      request: ListDomainsRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.DomainInfo.ReadOnly]
  def listDomainsPaginated(request: ListDomainsRequest): IO[AwsError, ReadOnly]
  def listOpenWorkflowExecutions(
      request: ListOpenWorkflowExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly]
  def listOpenWorkflowExecutionsPaginated(
      request: ListOpenWorkflowExecutionsRequest
  ): IO[AwsError, zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly]
  def listClosedWorkflowExecutions(
      request: ListClosedWorkflowExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly]
  def listClosedWorkflowExecutionsPaginated(
      request: ListClosedWorkflowExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.swf.model.ListClosedWorkflowExecutionsResponse.ReadOnly
  ]
  def registerDomain(request: RegisterDomainRequest): IO[AwsError, Unit]
  def getWorkflowExecutionHistory(
      request: GetWorkflowExecutionHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.HistoryEvent.ReadOnly]
  def getWorkflowExecutionHistoryPaginated(
      request: GetWorkflowExecutionHistoryRequest
  ): IO[
    AwsError,
    zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly
  ]
  def respondActivityTaskFailed(
      request: RespondActivityTaskFailedRequest
  ): IO[AwsError, Unit]
  def registerWorkflowType(
      request: RegisterWorkflowTypeRequest
  ): IO[AwsError, Unit]
  def listActivityTypes(
      request: ListActivityTypesRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.ActivityTypeInfo.ReadOnly]
  def listActivityTypesPaginated(
      request: ListActivityTypesRequest
  ): IO[AwsError, zio.aws.swf.model.ListActivityTypesResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def respondActivityTaskCompleted(
      request: RespondActivityTaskCompletedRequest
  ): IO[AwsError, Unit]
  def countOpenWorkflowExecutions(
      request: CountOpenWorkflowExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly
  ]
  def terminateWorkflowExecution(
      request: TerminateWorkflowExecutionRequest
  ): IO[AwsError, Unit]
  def countPendingActivityTasks(
      request: CountPendingActivityTasksRequest
  ): IO[AwsError, zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly]
  def respondDecisionTaskCompleted(
      request: RespondDecisionTaskCompletedRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def deprecateWorkflowType(
      request: DeprecateWorkflowTypeRequest
  ): IO[AwsError, Unit]
  def pollForDecisionTask(
      request: PollForDecisionTaskRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.HistoryEvent.ReadOnly]
  def pollForDecisionTaskPaginated(
      request: PollForDecisionTaskRequest
  ): IO[AwsError, zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly]
  def deprecateDomain(request: DeprecateDomainRequest): IO[AwsError, Unit]
  def respondActivityTaskCanceled(
      request: RespondActivityTaskCanceledRequest
  ): IO[AwsError, Unit]
  def requestCancelWorkflowExecution(
      request: RequestCancelWorkflowExecutionRequest
  ): IO[AwsError, Unit]
  def describeWorkflowType(
      request: DescribeWorkflowTypeRequest
  ): IO[AwsError, zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly]
  def undeprecateWorkflowType(
      request: UndeprecateWorkflowTypeRequest
  ): IO[AwsError, Unit]
  def recordActivityTaskHeartbeat(
      request: RecordActivityTaskHeartbeatRequest
  ): IO[
    AwsError,
    zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly
  ]
  def listWorkflowTypes(
      request: ListWorkflowTypesRequest
  ): ZStream[Any, AwsError, zio.aws.swf.model.WorkflowTypeInfo.ReadOnly]
  def listWorkflowTypesPaginated(
      request: ListWorkflowTypesRequest
  ): IO[AwsError, zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly]
  def describeWorkflowExecution(
      request: DescribeWorkflowExecutionRequest
  ): IO[AwsError, zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly]
  def deprecateActivityType(
      request: DeprecateActivityTypeRequest
  ): IO[AwsError, Unit]
}
object Swf {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Swf] = customized(identity)
  def customized(
      customization: SwfAsyncClientBuilder => SwfAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Swf] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SwfAsyncClientBuilder => SwfAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Swf] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SwfAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SwfAsyncClient, SwfAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SwfAsyncClient, SwfAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SwfImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SwfImpl[R](
      override val api: SwfAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Swf
      with AwsServiceBase[R] {
    override val serviceName: String = "Swf"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SwfImpl[R1] = new SwfImpl(api, newAspect, r)
    def registerActivityType(
        request: RegisterActivityTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest,
      RegisterActivityTypeResponse
    ]("registerActivityType", api.registerActivityType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeActivityType(
        request: DescribeActivityTypeRequest
    ): IO[AwsError, zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest,
        DescribeActivityTypeResponse
      ]("describeActivityType", api.describeActivityType)(
        request.buildAwsValue()
      ).map(zio.aws.swf.model.DescribeActivityTypeResponse.wrap)
        .provideEnvironment(r)
    def describeDomain(
        request: DescribeDomainRequest
    ): IO[AwsError, zio.aws.swf.model.DescribeDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.DescribeDomainRequest,
        DescribeDomainResponse
      ]("describeDomain", api.describeDomain)(request.buildAwsValue())
        .map(zio.aws.swf.model.DescribeDomainResponse.wrap)
        .provideEnvironment(r)
    def countClosedWorkflowExecutions(
        request: CountClosedWorkflowExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.CountClosedWorkflowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest,
      CountClosedWorkflowExecutionsResponse
    ]("countClosedWorkflowExecutions", api.countClosedWorkflowExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.CountClosedWorkflowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def startWorkflowExecution(
        request: StartWorkflowExecutionRequest
    ): IO[AwsError, zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest,
        StartWorkflowExecutionResponse
      ]("startWorkflowExecution", api.startWorkflowExecution)(
        request.buildAwsValue()
      ).map(zio.aws.swf.model.StartWorkflowExecutionResponse.wrap)
        .provideEnvironment(r)
    def undeprecateDomain(
        request: UndeprecateDomainRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest,
      UndeprecateDomainResponse
    ]("undeprecateDomain", api.undeprecateDomain)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def countPendingDecisionTasks(
        request: CountPendingDecisionTasksRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.CountPendingDecisionTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest,
      CountPendingDecisionTasksResponse
    ]("countPendingDecisionTasks", api.countPendingDecisionTasks)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.CountPendingDecisionTasksResponse.wrap)
      .provideEnvironment(r)
    def signalWorkflowExecution(
        request: SignalWorkflowExecutionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest,
      SignalWorkflowExecutionResponse
    ]("signalWorkflowExecution", api.signalWorkflowExecution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def undeprecateActivityType(
        request: UndeprecateActivityTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest,
      UndeprecateActivityTypeResponse
    ]("undeprecateActivityType", api.undeprecateActivityType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def pollForActivityTask(
        request: PollForActivityTaskRequest
    ): IO[AwsError, zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest,
        PollForActivityTaskResponse
      ]("pollForActivityTask", api.pollForActivityTask)(request.buildAwsValue())
        .map(zio.aws.swf.model.PollForActivityTaskResponse.wrap)
        .provideEnvironment(r)
    def listDomains(
        request: ListDomainsRequest
    ): ZStream[Any, AwsError, zio.aws.swf.model.DomainInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.swf.model.ListDomainsRequest,
        DomainInfo,
        ListDomainsPublisher
      ]("listDomains", api.listDomainsPaginator, _.domainInfos())(
        request.buildAwsValue()
      ).map(item => zio.aws.swf.model.DomainInfo.wrap(item))
        .provideEnvironment(r)
    def listDomainsPaginated(
        request: ListDomainsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.ListDomainsRequest,
      ListDomainsResponse
    ]("listDomains", api.listDomains)(request.buildAwsValue())
      .map(zio.aws.swf.model.ListDomainsResponse.wrap)
      .provideEnvironment(r)
    def listOpenWorkflowExecutions(
        request: ListOpenWorkflowExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest,
      WorkflowExecutionInfo,
      ListOpenWorkflowExecutionsPublisher
    ](
      "listOpenWorkflowExecutions",
      api.listOpenWorkflowExecutionsPaginator,
      _.executionInfos()
    )(request.buildAwsValue())
      .map(item => zio.aws.swf.model.WorkflowExecutionInfo.wrap(item))
      .provideEnvironment(r)
    def listOpenWorkflowExecutionsPaginated(
        request: ListOpenWorkflowExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest,
      ListOpenWorkflowExecutionsResponse
    ]("listOpenWorkflowExecutions", api.listOpenWorkflowExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def listClosedWorkflowExecutions(
        request: ListClosedWorkflowExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest,
      WorkflowExecutionInfo,
      ListClosedWorkflowExecutionsPublisher
    ](
      "listClosedWorkflowExecutions",
      api.listClosedWorkflowExecutionsPaginator,
      _.executionInfos()
    )(request.buildAwsValue())
      .map(item => zio.aws.swf.model.WorkflowExecutionInfo.wrap(item))
      .provideEnvironment(r)
    def listClosedWorkflowExecutionsPaginated(
        request: ListClosedWorkflowExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.ListClosedWorkflowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest,
      ListClosedWorkflowExecutionsResponse
    ]("listClosedWorkflowExecutions", api.listClosedWorkflowExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.ListClosedWorkflowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def registerDomain(request: RegisterDomainRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.RegisterDomainRequest,
        RegisterDomainResponse
      ]("registerDomain", api.registerDomain)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getWorkflowExecutionHistory(
        request: GetWorkflowExecutionHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.swf.model.HistoryEvent.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest,
        HistoryEvent,
        GetWorkflowExecutionHistoryPublisher
      ](
        "getWorkflowExecutionHistory",
        api.getWorkflowExecutionHistoryPaginator,
        _.events()
      )(request.buildAwsValue())
        .map(item => zio.aws.swf.model.HistoryEvent.wrap(item))
        .provideEnvironment(r)
    def getWorkflowExecutionHistoryPaginated(
        request: GetWorkflowExecutionHistoryRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest,
      GetWorkflowExecutionHistoryResponse
    ]("getWorkflowExecutionHistory", api.getWorkflowExecutionHistory)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.wrap)
      .provideEnvironment(r)
    def respondActivityTaskFailed(
        request: RespondActivityTaskFailedRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest,
      RespondActivityTaskFailedResponse
    ]("respondActivityTaskFailed", api.respondActivityTaskFailed)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def registerWorkflowType(
        request: RegisterWorkflowTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest,
      RegisterWorkflowTypeResponse
    ]("registerWorkflowType", api.registerWorkflowType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listActivityTypes(
        request: ListActivityTypesRequest
    ): ZStream[Any, AwsError, zio.aws.swf.model.ActivityTypeInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.swf.model.ListActivityTypesRequest,
        ActivityTypeInfo,
        ListActivityTypesPublisher
      ]("listActivityTypes", api.listActivityTypesPaginator, _.typeInfos())(
        request.buildAwsValue()
      ).map(item => zio.aws.swf.model.ActivityTypeInfo.wrap(item))
        .provideEnvironment(r)
    def listActivityTypesPaginated(
        request: ListActivityTypesRequest
    ): IO[AwsError, zio.aws.swf.model.ListActivityTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.ListActivityTypesRequest,
        ListActivityTypesResponse
      ]("listActivityTypes", api.listActivityTypes)(request.buildAwsValue())
        .map(zio.aws.swf.model.ListActivityTypesResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def respondActivityTaskCompleted(
        request: RespondActivityTaskCompletedRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest,
      RespondActivityTaskCompletedResponse
    ]("respondActivityTaskCompleted", api.respondActivityTaskCompleted)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def countOpenWorkflowExecutions(
        request: CountOpenWorkflowExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest,
      CountOpenWorkflowExecutionsResponse
    ]("countOpenWorkflowExecutions", api.countOpenWorkflowExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def terminateWorkflowExecution(
        request: TerminateWorkflowExecutionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest,
      TerminateWorkflowExecutionResponse
    ]("terminateWorkflowExecution", api.terminateWorkflowExecution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def countPendingActivityTasks(
        request: CountPendingActivityTasksRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.CountPendingActivityTasksRequest,
      CountPendingActivityTasksResponse
    ]("countPendingActivityTasks", api.countPendingActivityTasks)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.CountPendingActivityTasksResponse.wrap)
      .provideEnvironment(r)
    def respondDecisionTaskCompleted(
        request: RespondDecisionTaskCompletedRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest,
      RespondDecisionTaskCompletedResponse
    ]("respondDecisionTaskCompleted", api.respondDecisionTaskCompleted)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.swf.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deprecateWorkflowType(
        request: DeprecateWorkflowTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeRequest,
      DeprecateWorkflowTypeResponse
    ]("deprecateWorkflowType", api.deprecateWorkflowType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def pollForDecisionTask(
        request: PollForDecisionTaskRequest
    ): ZStream[Any, AwsError, zio.aws.swf.model.HistoryEvent.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest,
        HistoryEvent,
        PollForDecisionTaskPublisher
      ]("pollForDecisionTask", api.pollForDecisionTaskPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.swf.model.HistoryEvent.wrap(item))
        .provideEnvironment(r)
    def pollForDecisionTaskPaginated(
        request: PollForDecisionTaskRequest
    ): IO[AwsError, zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest,
        PollForDecisionTaskResponse
      ]("pollForDecisionTask", api.pollForDecisionTask)(request.buildAwsValue())
        .map(zio.aws.swf.model.PollForDecisionTaskResponse.wrap)
        .provideEnvironment(r)
    def deprecateDomain(request: DeprecateDomainRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.DeprecateDomainRequest,
        DeprecateDomainResponse
      ]("deprecateDomain", api.deprecateDomain)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def respondActivityTaskCanceled(
        request: RespondActivityTaskCanceledRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest,
      RespondActivityTaskCanceledResponse
    ]("respondActivityTaskCanceled", api.respondActivityTaskCanceled)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def requestCancelWorkflowExecution(
        request: RequestCancelWorkflowExecutionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest,
      RequestCancelWorkflowExecutionResponse
    ]("requestCancelWorkflowExecution", api.requestCancelWorkflowExecution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeWorkflowType(
        request: DescribeWorkflowTypeRequest
    ): IO[AwsError, zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest,
        DescribeWorkflowTypeResponse
      ]("describeWorkflowType", api.describeWorkflowType)(
        request.buildAwsValue()
      ).map(zio.aws.swf.model.DescribeWorkflowTypeResponse.wrap)
        .provideEnvironment(r)
    def undeprecateWorkflowType(
        request: UndeprecateWorkflowTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeRequest,
      UndeprecateWorkflowTypeResponse
    ]("undeprecateWorkflowType", api.undeprecateWorkflowType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def recordActivityTaskHeartbeat(
        request: RecordActivityTaskHeartbeatRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest,
      RecordActivityTaskHeartbeatResponse
    ]("recordActivityTaskHeartbeat", api.recordActivityTaskHeartbeat)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.wrap)
      .provideEnvironment(r)
    def listWorkflowTypes(
        request: ListWorkflowTypesRequest
    ): ZStream[Any, AwsError, zio.aws.swf.model.WorkflowTypeInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest,
        WorkflowTypeInfo,
        ListWorkflowTypesPublisher
      ]("listWorkflowTypes", api.listWorkflowTypesPaginator, _.typeInfos())(
        request.buildAwsValue()
      ).map(item => zio.aws.swf.model.WorkflowTypeInfo.wrap(item))
        .provideEnvironment(r)
    def listWorkflowTypesPaginated(
        request: ListWorkflowTypesRequest
    ): IO[AwsError, zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest,
        ListWorkflowTypesResponse
      ]("listWorkflowTypes", api.listWorkflowTypes)(request.buildAwsValue())
        .map(zio.aws.swf.model.ListWorkflowTypesResponse.wrap)
        .provideEnvironment(r)
    def describeWorkflowExecution(
        request: DescribeWorkflowExecutionRequest
    ): IO[
      AwsError,
      zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest,
      DescribeWorkflowExecutionResponse
    ]("describeWorkflowExecution", api.describeWorkflowExecution)(
      request.buildAwsValue()
    ).map(zio.aws.swf.model.DescribeWorkflowExecutionResponse.wrap)
      .provideEnvironment(r)
    def deprecateActivityType(
        request: DeprecateActivityTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest,
      DeprecateActivityTypeResponse
    ]("deprecateActivityType", api.deprecateActivityType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
  }
  def registerActivityType(
      request: RegisterActivityTypeRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerActivityType(request))
  def describeActivityType(request: DescribeActivityTypeRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.DescribeActivityTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeActivityType(request))
  def describeDomain(request: DescribeDomainRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.DescribeDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomain(request))
  def countClosedWorkflowExecutions(
      request: CountClosedWorkflowExecutionsRequest
  ): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.CountClosedWorkflowExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.countClosedWorkflowExecutions(request))
  def startWorkflowExecution(request: StartWorkflowExecutionRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startWorkflowExecution(request))
  def undeprecateDomain(
      request: UndeprecateDomainRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.undeprecateDomain(request))
  def countPendingDecisionTasks(request: CountPendingDecisionTasksRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.CountPendingDecisionTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.countPendingDecisionTasks(request))
  def signalWorkflowExecution(
      request: SignalWorkflowExecutionRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.signalWorkflowExecution(request))
  def undeprecateActivityType(
      request: UndeprecateActivityTypeRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.undeprecateActivityType(request))
  def pollForActivityTask(request: PollForActivityTaskRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pollForActivityTask(request))
  def listDomains(
      request: ListDomainsRequest
  ): ZStream[zio.aws.swf.Swf, AwsError, zio.aws.swf.model.DomainInfo.ReadOnly] =
    ZStream.serviceWithStream(_.listDomains(request))
  def listDomainsPaginated(
      request: ListDomainsRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listDomainsPaginated(request))
  def listOpenWorkflowExecutions(
      request: ListOpenWorkflowExecutionsRequest
  ): ZStream[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listOpenWorkflowExecutions(request))
  def listOpenWorkflowExecutionsPaginated(
      request: ListOpenWorkflowExecutionsRequest
  ): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOpenWorkflowExecutionsPaginated(request))
  def listClosedWorkflowExecutions(
      request: ListClosedWorkflowExecutionsRequest
  ): ZStream[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listClosedWorkflowExecutions(request))
  def listClosedWorkflowExecutionsPaginated(
      request: ListClosedWorkflowExecutionsRequest
  ): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.ListClosedWorkflowExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClosedWorkflowExecutionsPaginated(request))
  def registerDomain(
      request: RegisterDomainRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerDomain(request))
  def getWorkflowExecutionHistory(
      request: GetWorkflowExecutionHistoryRequest
  ): ZStream[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.HistoryEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.getWorkflowExecutionHistory(request))
  def getWorkflowExecutionHistoryPaginated(
      request: GetWorkflowExecutionHistoryRequest
  ): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflowExecutionHistoryPaginated(request))
  def respondActivityTaskFailed(
      request: RespondActivityTaskFailedRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.respondActivityTaskFailed(request))
  def registerWorkflowType(
      request: RegisterWorkflowTypeRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerWorkflowType(request))
  def listActivityTypes(request: ListActivityTypesRequest): ZStream[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.ActivityTypeInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listActivityTypes(request))
  def listActivityTypesPaginated(request: ListActivityTypesRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.ListActivityTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listActivityTypesPaginated(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def respondActivityTaskCompleted(
      request: RespondActivityTaskCompletedRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.respondActivityTaskCompleted(request))
  def countOpenWorkflowExecutions(
      request: CountOpenWorkflowExecutionsRequest
  ): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.countOpenWorkflowExecutions(request))
  def terminateWorkflowExecution(
      request: TerminateWorkflowExecutionRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.terminateWorkflowExecution(request))
  def countPendingActivityTasks(request: CountPendingActivityTasksRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.countPendingActivityTasks(request))
  def respondDecisionTaskCompleted(
      request: RespondDecisionTaskCompletedRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.respondDecisionTaskCompleted(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def deprecateWorkflowType(
      request: DeprecateWorkflowTypeRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deprecateWorkflowType(request))
  def pollForDecisionTask(request: PollForDecisionTaskRequest): ZStream[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.HistoryEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.pollForDecisionTask(request))
  def pollForDecisionTaskPaginated(request: PollForDecisionTaskRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pollForDecisionTaskPaginated(request))
  def deprecateDomain(
      request: DeprecateDomainRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deprecateDomain(request))
  def respondActivityTaskCanceled(
      request: RespondActivityTaskCanceledRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.respondActivityTaskCanceled(request))
  def requestCancelWorkflowExecution(
      request: RequestCancelWorkflowExecutionRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.requestCancelWorkflowExecution(request))
  def describeWorkflowType(request: DescribeWorkflowTypeRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkflowType(request))
  def undeprecateWorkflowType(
      request: UndeprecateWorkflowTypeRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.undeprecateWorkflowType(request))
  def recordActivityTaskHeartbeat(
      request: RecordActivityTaskHeartbeatRequest
  ): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.RecordActivityTaskHeartbeatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.recordActivityTaskHeartbeat(request))
  def listWorkflowTypes(request: ListWorkflowTypesRequest): ZStream[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.WorkflowTypeInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflowTypes(request))
  def listWorkflowTypesPaginated(request: ListWorkflowTypesRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.ListWorkflowTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowTypesPaginated(request))
  def describeWorkflowExecution(request: DescribeWorkflowExecutionRequest): ZIO[
    zio.aws.swf.Swf,
    AwsError,
    zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkflowExecution(request))
  def deprecateActivityType(
      request: DeprecateActivityTypeRequest
  ): ZIO[zio.aws.swf.Swf, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deprecateActivityType(request))
}
