package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait CancelTimerFailedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.CancelTimerFailedCause
}
object CancelTimerFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.CancelTimerFailedCause
  ): zio.aws.swf.model.CancelTimerFailedCause = value match {
    case software.amazon.awssdk.services.swf.model.CancelTimerFailedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.CancelTimerFailedCause.TIMER_ID_UNKNOWN =>
      val r = TIMER_ID_UNKNOWN
      r
    case software.amazon.awssdk.services.swf.model.CancelTimerFailedCause.OPERATION_NOT_PERMITTED =>
      val r = OPERATION_NOT_PERMITTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.CancelTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.CancelTimerFailedCause =
      software.amazon.awssdk.services.swf.model.CancelTimerFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object TIMER_ID_UNKNOWN
      extends zio.aws.swf.model.CancelTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.CancelTimerFailedCause =
      software.amazon.awssdk.services.swf.model.CancelTimerFailedCause.TIMER_ID_UNKNOWN
  }
  case object OPERATION_NOT_PERMITTED
      extends zio.aws.swf.model.CancelTimerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.CancelTimerFailedCause =
      software.amazon.awssdk.services.swf.model.CancelTimerFailedCause.OPERATION_NOT_PERMITTED
  }
}
