package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class CountPendingDecisionTasksRequest(
    domain: DomainName,
    taskList: zio.aws.swf.model.TaskList
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest = {
    import CountPendingDecisionTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .taskList(taskList.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.CountPendingDecisionTasksRequest.ReadOnly =
    zio.aws.swf.model.CountPendingDecisionTasksRequest.wrap(buildAwsValue())
}
object CountPendingDecisionTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CountPendingDecisionTasksRequest =
      zio.aws.swf.model
        .CountPendingDecisionTasksRequest(domain, taskList.asEditable)
    def domain: DomainName
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest
  ) extends zio.aws.swf.model.CountPendingDecisionTasksRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest
  ): zio.aws.swf.model.CountPendingDecisionTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
