package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DeprecateActivityTypeRequest(
    domain: DomainName,
    activityType: zio.aws.swf.model.ActivityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest = {
    import DeprecateActivityTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .activityType(activityType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DeprecateActivityTypeRequest.ReadOnly =
    zio.aws.swf.model.DeprecateActivityTypeRequest.wrap(buildAwsValue())
}
object DeprecateActivityTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DeprecateActivityTypeRequest =
      zio.aws.swf.model
        .DeprecateActivityTypeRequest(domain, activityType.asEditable)
    def domain: DomainName
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest
  ) extends zio.aws.swf.model.DeprecateActivityTypeRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest
  ): zio.aws.swf.model.DeprecateActivityTypeRequest.ReadOnly = new Wrapper(impl)
}
