package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListOpenWorkflowExecutionsResponse(
    executionInfos: Iterable[zio.aws.swf.model.WorkflowExecutionInfo],
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse = {
    import ListOpenWorkflowExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse
      .builder()
      .executionInfos(executionInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly =
    zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.wrap(buildAwsValue())
}
object ListOpenWorkflowExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListOpenWorkflowExecutionsResponse =
      zio.aws.swf.model.ListOpenWorkflowExecutionsResponse(
        executionInfos.map { item =>
          item.asEditable
        },
        nextPageToken.map(value => value)
      )
    def executionInfos: List[zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly]
    def nextPageToken: Option[PageToken]
    def getExecutionInfos: ZIO[Any, Nothing, List[
      zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
    ]] = ZIO.succeed(executionInfos)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse
  ) extends zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly {
    override val executionInfos
        : List[zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly] = impl
      .executionInfos()
      .asScala
      .map { item =>
        zio.aws.swf.model.WorkflowExecutionInfo.wrap(item)
      }
      .toList
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse
  ): zio.aws.swf.model.ListOpenWorkflowExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
