package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class CancelWorkflowExecutionFailedEventAttributes(
    cause: zio.aws.swf.model.CancelWorkflowExecutionFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedEventAttributes = {
    import CancelWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedEventAttributes
      .builder()
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object CancelWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes(
        cause,
        decisionTaskCompletedEventId
      )
    def cause: zio.aws.swf.model.CancelWorkflowExecutionFailedCause
    def decisionTaskCompletedEventId: EventId
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.CancelWorkflowExecutionFailedCause
    ] = ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val cause: zio.aws.swf.model.CancelWorkflowExecutionFailedCause =
      zio.aws.swf.model.CancelWorkflowExecutionFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
