package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, TimerId}
import scala.jdk.CollectionConverters._
final case class TimerFiredEventAttributes(
    timerId: TimerId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes = {
    import TimerFiredEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly =
    zio.aws.swf.model.TimerFiredEventAttributes.wrap(buildAwsValue())
}
object TimerFiredEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TimerFiredEventAttributes =
      zio.aws.swf.model.TimerFiredEventAttributes(timerId, startedEventId)
    def timerId: TimerId
    def startedEventId: EventId
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes
  ) extends zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes
  ): zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly = new Wrapper(impl)
}
